/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllocationIdListCopier;
import software.amazon.awssdk.services.ec2.model.ConnectivityType;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNatGatewayRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateNatGatewayRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::allocationId)).setter(CreateNatGatewayRequest.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::clientToken)).setter(CreateNatGatewayRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::dryRun)).setter(CreateNatGatewayRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::subnetId)).setter(CreateNatGatewayRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::tagSpecifications)).setter(CreateNatGatewayRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectivityType").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::connectivityTypeAsString)).setter(CreateNatGatewayRequest.setter(Builder::connectivityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityType").unmarshallLocationName("ConnectivityType").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::privateIpAddress)).setter(CreateNatGatewayRequest.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build()}).build();
    private static final SdkField<List<String>> SECONDARY_ALLOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondaryAllocationIds").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::secondaryAllocationIds)).setter(CreateNatGatewayRequest.setter(Builder::secondaryAllocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAllocationId").unmarshallLocationName("SecondaryAllocationId").build(), ListTrait.builder().memberLocationName("AllocationId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECONDARY_PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondaryPrivateIpAddresses").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::secondaryPrivateIpAddresses)).setter(CreateNatGatewayRequest.setter(Builder::secondaryPrivateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddress").unmarshallLocationName("SecondaryPrivateIpAddress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondaryPrivateIpAddressCount").getter(CreateNatGatewayRequest.getter(CreateNatGatewayRequest::secondaryPrivateIpAddressCount)).setter(CreateNatGatewayRequest.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("SecondaryPrivateIpAddressCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, SUBNET_ID_FIELD, TAG_SPECIFICATIONS_FIELD, CONNECTIVITY_TYPE_FIELD, PRIVATE_IP_ADDRESS_FIELD, SECONDARY_ALLOCATION_IDS_FIELD, SECONDARY_PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AllocationId", ALLOCATION_ID_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("ConnectivityType", CONNECTIVITY_TYPE_FIELD);
            this.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
            this.put("SecondaryAllocationId", SECONDARY_ALLOCATION_IDS_FIELD);
            this.put("SecondaryPrivateIpAddress", SECONDARY_PRIVATE_IP_ADDRESSES_FIELD);
            this.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
        }
    });
    private final String allocationId;
    private final String clientToken;
    private final Boolean dryRun;
    private final String subnetId;
    private final List<TagSpecification> tagSpecifications;
    private final String connectivityType;
    private final String privateIpAddress;
    private final List<String> secondaryAllocationIds;
    private final List<String> secondaryPrivateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;

    private CreateNatGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.subnetId = builder.subnetId;
        this.tagSpecifications = builder.tagSpecifications;
        this.connectivityType = builder.connectivityType;
        this.privateIpAddress = builder.privateIpAddress;
        this.secondaryAllocationIds = builder.secondaryAllocationIds;
        this.secondaryPrivateIpAddresses = builder.secondaryPrivateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final ConnectivityType connectivityType() {
        return ConnectivityType.fromValue(this.connectivityType);
    }

    public final String connectivityTypeAsString() {
        return this.connectivityType;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasSecondaryAllocationIds() {
        return this.secondaryAllocationIds != null && !(this.secondaryAllocationIds instanceof SdkAutoConstructList);
    }

    public final List<String> secondaryAllocationIds() {
        return this.secondaryAllocationIds;
    }

    public final boolean hasSecondaryPrivateIpAddresses() {
        return this.secondaryPrivateIpAddresses != null && !(this.secondaryPrivateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> secondaryPrivateIpAddresses() {
        return this.secondaryPrivateIpAddresses;
    }

    public final Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryAllocationIds() ? this.secondaryAllocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryPrivateIpAddresses() ? this.secondaryPrivateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayRequest)) {
            return false;
        }
        CreateNatGatewayRequest other = (CreateNatGatewayRequest)((Object)obj);
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.connectivityTypeAsString(), other.connectivityTypeAsString()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasSecondaryAllocationIds() == other.hasSecondaryAllocationIds() && Objects.equals(this.secondaryAllocationIds(), other.secondaryAllocationIds()) && this.hasSecondaryPrivateIpAddresses() == other.hasSecondaryPrivateIpAddresses() && Objects.equals(this.secondaryPrivateIpAddresses(), other.secondaryPrivateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNatGatewayRequest").add("AllocationId", (Object)this.allocationId()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("SubnetId", (Object)this.subnetId()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ConnectivityType", (Object)this.connectivityTypeAsString()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("SecondaryAllocationIds", this.hasSecondaryAllocationIds() ? this.secondaryAllocationIds() : null).add("SecondaryPrivateIpAddresses", this.hasSecondaryPrivateIpAddresses() ? this.secondaryPrivateIpAddresses() : null).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ConnectivityType": {
                return Optional.ofNullable(clazz.cast(this.connectivityTypeAsString()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "SecondaryAllocationIds": {
                return Optional.ofNullable(clazz.cast(this.secondaryAllocationIds()));
            }
            case "SecondaryPrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateNatGatewayRequest, T> g) {
        return obj -> g.apply((CreateNatGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String allocationId;
        private String clientToken;
        private Boolean dryRun;
        private String subnetId;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String connectivityType;
        private String privateIpAddress;
        private List<String> secondaryAllocationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> secondaryPrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNatGatewayRequest model) {
            super(model);
            this.allocationId(model.allocationId);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.subnetId(model.subnetId);
            this.tagSpecifications(model.tagSpecifications);
            this.connectivityType(model.connectivityType);
            this.privateIpAddress(model.privateIpAddress);
            this.secondaryAllocationIds(model.secondaryAllocationIds);
            this.secondaryPrivateIpAddresses(model.secondaryPrivateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectivityType() {
            return this.connectivityType;
        }

        public final void setConnectivityType(String connectivityType) {
            this.connectivityType = connectivityType;
        }

        @Override
        public final Builder connectivityType(String connectivityType) {
            this.connectivityType = connectivityType;
            return this;
        }

        @Override
        public final Builder connectivityType(ConnectivityType connectivityType) {
            this.connectivityType(connectivityType == null ? null : connectivityType.toString());
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final Collection<String> getSecondaryAllocationIds() {
            if (this.secondaryAllocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.secondaryAllocationIds;
        }

        public final void setSecondaryAllocationIds(Collection<String> secondaryAllocationIds) {
            this.secondaryAllocationIds = AllocationIdListCopier.copy(secondaryAllocationIds);
        }

        @Override
        public final Builder secondaryAllocationIds(Collection<String> secondaryAllocationIds) {
            this.secondaryAllocationIds = AllocationIdListCopier.copy(secondaryAllocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAllocationIds(String ... secondaryAllocationIds) {
            this.secondaryAllocationIds(Arrays.asList(secondaryAllocationIds));
            return this;
        }

        public final Collection<String> getSecondaryPrivateIpAddresses() {
            if (this.secondaryPrivateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.secondaryPrivateIpAddresses;
        }

        public final void setSecondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses = IpListCopier.copy(secondaryPrivateIpAddresses);
        }

        @Override
        public final Builder secondaryPrivateIpAddresses(Collection<String> secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses = IpListCopier.copy(secondaryPrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryPrivateIpAddresses(String ... secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses(Arrays.asList(secondaryPrivateIpAddresses));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNatGatewayRequest build() {
            return new CreateNatGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNatGatewayRequest> {
        public Builder allocationId(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder subnetId(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder connectivityType(String var1);

        public Builder connectivityType(ConnectivityType var1);

        public Builder privateIpAddress(String var1);

        public Builder secondaryAllocationIds(Collection<String> var1);

        public Builder secondaryAllocationIds(String ... var1);

        public Builder secondaryPrivateIpAddresses(Collection<String> var1);

        public Builder secondaryPrivateIpAddresses(String ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

