/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamPoolSourceResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPoolSourceResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPoolSourceResource> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamPoolSourceResource.getter(IpamPoolSourceResource::resourceId)).setter(IpamPoolSourceResource.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamPoolSourceResource.getter(IpamPoolSourceResource::resourceTypeAsString)).setter(IpamPoolSourceResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamPoolSourceResource.getter(IpamPoolSourceResource::resourceRegion)).setter(IpamPoolSourceResource.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(IpamPoolSourceResource.getter(IpamPoolSourceResource::resourceOwner)).setter(IpamPoolSourceResource.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").unmarshallLocationName("resourceOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_REGION_FIELD, RESOURCE_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceRegion", RESOURCE_REGION_FIELD);
            this.put("ResourceOwner", RESOURCE_OWNER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String resourceType;
    private final String resourceRegion;
    private final String resourceOwner;

    private IpamPoolSourceResource(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceRegion = builder.resourceRegion;
        this.resourceOwner = builder.resourceOwner;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final IpamPoolSourceResourceType resourceType() {
        return IpamPoolSourceResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String resourceOwner() {
        return this.resourceOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPoolSourceResource)) {
            return false;
        }
        IpamPoolSourceResource other = (IpamPoolSourceResource)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceOwner(), other.resourceOwner());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPoolSourceResource").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceOwner", (Object)this.resourceOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamPoolSourceResource, T> g) {
        return obj -> g.apply((IpamPoolSourceResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String resourceRegion;
        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPoolSourceResource model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceRegion(model.resourceRegion);
            this.resourceOwner(model.resourceOwner);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPoolSourceResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public IpamPoolSourceResource build() {
            return new IpamPoolSourceResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPoolSourceResource> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamPoolSourceResourceType var1);

        public Builder resourceRegion(String var1);

        public Builder resourceOwner(String var1);
    }
}

