/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.StorageLocation;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFpgaImageRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateFpgaImageRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::dryRun)).setter(CreateFpgaImageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<StorageLocation> INPUT_STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputStorageLocation").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::inputStorageLocation)).setter(CreateFpgaImageRequest.setter(Builder::inputStorageLocation)).constructor(StorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStorageLocation").unmarshallLocationName("InputStorageLocation").build()}).build();
    private static final SdkField<StorageLocation> LOGS_STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogsStorageLocation").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::logsStorageLocation)).setter(CreateFpgaImageRequest.setter(Builder::logsStorageLocation)).constructor(StorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsStorageLocation").unmarshallLocationName("LogsStorageLocation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::description)).setter(CreateFpgaImageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::name)).setter(CreateFpgaImageRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::clientToken)).setter(CreateFpgaImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateFpgaImageRequest.getter(CreateFpgaImageRequest::tagSpecifications)).setter(CreateFpgaImageRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, INPUT_STORAGE_LOCATION_FIELD, LOGS_STORAGE_LOCATION_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("InputStorageLocation", INPUT_STORAGE_LOCATION_FIELD);
            this.put("LogsStorageLocation", LOGS_STORAGE_LOCATION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        }
    });
    private final Boolean dryRun;
    private final StorageLocation inputStorageLocation;
    private final StorageLocation logsStorageLocation;
    private final String description;
    private final String name;
    private final String clientToken;
    private final List<TagSpecification> tagSpecifications;

    private CreateFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.inputStorageLocation = builder.inputStorageLocation;
        this.logsStorageLocation = builder.logsStorageLocation;
        this.description = builder.description;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final StorageLocation inputStorageLocation() {
        return this.inputStorageLocation;
    }

    public final StorageLocation logsStorageLocation() {
        return this.logsStorageLocation;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageRequest)) {
            return false;
        }
        CreateFpgaImageRequest other = (CreateFpgaImageRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.inputStorageLocation(), other.inputStorageLocation()) && Objects.equals(this.logsStorageLocation(), other.logsStorageLocation()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFpgaImageRequest").add("DryRun", (Object)this.dryRun()).add("InputStorageLocation", (Object)this.inputStorageLocation()).add("LogsStorageLocation", (Object)this.logsStorageLocation()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "InputStorageLocation": {
                return Optional.ofNullable(clazz.cast(this.inputStorageLocation()));
            }
            case "LogsStorageLocation": {
                return Optional.ofNullable(clazz.cast(this.logsStorageLocation()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFpgaImageRequest, T> g) {
        return obj -> g.apply((CreateFpgaImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private StorageLocation inputStorageLocation;
        private StorageLocation logsStorageLocation;
        private String description;
        private String name;
        private String clientToken;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.inputStorageLocation(model.inputStorageLocation);
            this.logsStorageLocation(model.logsStorageLocation);
            this.description(model.description);
            this.name(model.name);
            this.clientToken(model.clientToken);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final StorageLocation.Builder getInputStorageLocation() {
            return this.inputStorageLocation != null ? this.inputStorageLocation.toBuilder() : null;
        }

        public final void setInputStorageLocation(StorageLocation.BuilderImpl inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation != null ? inputStorageLocation.build() : null;
        }

        @Override
        public final Builder inputStorageLocation(StorageLocation inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation;
            return this;
        }

        public final StorageLocation.Builder getLogsStorageLocation() {
            return this.logsStorageLocation != null ? this.logsStorageLocation.toBuilder() : null;
        }

        public final void setLogsStorageLocation(StorageLocation.BuilderImpl logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation != null ? logsStorageLocation.build() : null;
        }

        @Override
        public final Builder logsStorageLocation(StorageLocation logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFpgaImageRequest build() {
            return new CreateFpgaImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFpgaImageRequest> {
        public Builder dryRun(Boolean var1);

        public Builder inputStorageLocation(StorageLocation var1);

        default public Builder inputStorageLocation(Consumer<StorageLocation.Builder> inputStorageLocation) {
            return this.inputStorageLocation((StorageLocation)((StorageLocation.Builder)StorageLocation.builder().applyMutation(inputStorageLocation)).build());
        }

        public Builder logsStorageLocation(StorageLocation var1);

        default public Builder logsStorageLocation(Consumer<StorageLocation.Builder> logsStorageLocation) {
            return this.logsStorageLocation((StorageLocation)((StorageLocation.Builder)StorageLocation.builder().applyMutation(logsStorageLocation)).build());
        }

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

