/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceEventWindowRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceEventWindowRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyInstanceEventWindowRequest.getter(ModifyInstanceEventWindowRequest::dryRun)).setter(ModifyInstanceEventWindowRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ModifyInstanceEventWindowRequest.getter(ModifyInstanceEventWindowRequest::name)).setter(ModifyInstanceEventWindowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceEventWindowId").getter(ModifyInstanceEventWindowRequest.getter(ModifyInstanceEventWindowRequest::instanceEventWindowId)).setter(ModifyInstanceEventWindowRequest.setter(Builder::instanceEventWindowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId").unmarshallLocationName("InstanceEventWindowId").build()}).build();
    private static final SdkField<List<InstanceEventWindowTimeRangeRequest>> TIME_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeRanges").getter(ModifyInstanceEventWindowRequest.getter(ModifyInstanceEventWindowRequest::timeRanges)).setter(ModifyInstanceEventWindowRequest.setter(Builder::timeRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").unmarshallLocationName("TimeRange").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceEventWindowTimeRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CronExpression").getter(ModifyInstanceEventWindowRequest.getter(ModifyInstanceEventWindowRequest::cronExpression)).setter(ModifyInstanceEventWindowRequest.setter(Builder::cronExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").unmarshallLocationName("CronExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, NAME_FIELD, INSTANCE_EVENT_WINDOW_ID_FIELD, TIME_RANGES_FIELD, CRON_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("InstanceEventWindowId", INSTANCE_EVENT_WINDOW_ID_FIELD);
            this.put("TimeRange", TIME_RANGES_FIELD);
            this.put("CronExpression", CRON_EXPRESSION_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String name;
    private final String instanceEventWindowId;
    private final List<InstanceEventWindowTimeRangeRequest> timeRanges;
    private final String cronExpression;

    private ModifyInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.name = builder.name;
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.timeRanges = builder.timeRanges;
        this.cronExpression = builder.cronExpression;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String name() {
        return this.name;
    }

    public final String instanceEventWindowId() {
        return this.instanceEventWindowId;
    }

    public final boolean hasTimeRanges() {
        return this.timeRanges != null && !(this.timeRanges instanceof SdkAutoConstructList);
    }

    public final List<InstanceEventWindowTimeRangeRequest> timeRanges() {
        return this.timeRanges;
    }

    public final String cronExpression() {
        return this.cronExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeRanges() ? this.timeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cronExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceEventWindowRequest)) {
            return false;
        }
        ModifyInstanceEventWindowRequest other = (ModifyInstanceEventWindowRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceEventWindowId(), other.instanceEventWindowId()) && this.hasTimeRanges() == other.hasTimeRanges() && Objects.equals(this.timeRanges(), other.timeRanges()) && Objects.equals(this.cronExpression(), other.cronExpression());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceEventWindowRequest").add("DryRun", (Object)this.dryRun()).add("Name", (Object)this.name()).add("InstanceEventWindowId", (Object)this.instanceEventWindowId()).add("TimeRanges", this.hasTimeRanges() ? this.timeRanges() : null).add("CronExpression", (Object)this.cronExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InstanceEventWindowId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindowId()));
            }
            case "TimeRanges": {
                return Optional.ofNullable(clazz.cast(this.timeRanges()));
            }
            case "CronExpression": {
                return Optional.ofNullable(clazz.cast(this.cronExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((ModifyInstanceEventWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String name;
        private String instanceEventWindowId;
        private List<InstanceEventWindowTimeRangeRequest> timeRanges = DefaultSdkAutoConstructList.getInstance();
        private String cronExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceEventWindowRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.name(model.name);
            this.instanceEventWindowId(model.instanceEventWindowId);
            this.timeRanges(model.timeRanges);
            this.cronExpression(model.cronExpression);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceEventWindowId() {
            return this.instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final List<InstanceEventWindowTimeRangeRequest.Builder> getTimeRanges() {
            List<InstanceEventWindowTimeRangeRequest.Builder> result = InstanceEventWindowTimeRangeRequestSetCopier.copyToBuilder(this.timeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeRanges(Collection<InstanceEventWindowTimeRangeRequest.BuilderImpl> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeRequestSetCopier.copyFromBuilder(timeRanges);
        }

        @Override
        public final Builder timeRanges(Collection<InstanceEventWindowTimeRangeRequest> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeRequestSetCopier.copy(timeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(InstanceEventWindowTimeRangeRequest ... timeRanges) {
            this.timeRanges(Arrays.asList(timeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(Consumer<InstanceEventWindowTimeRangeRequest.Builder> ... timeRanges) {
            this.timeRanges(Stream.of(timeRanges).map(c -> (InstanceEventWindowTimeRangeRequest)((InstanceEventWindowTimeRangeRequest.Builder)InstanceEventWindowTimeRangeRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCronExpression() {
            return this.cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceEventWindowRequest build() {
            return new ModifyInstanceEventWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceEventWindowRequest> {
        public Builder dryRun(Boolean var1);

        public Builder name(String var1);

        public Builder instanceEventWindowId(String var1);

        public Builder timeRanges(Collection<InstanceEventWindowTimeRangeRequest> var1);

        public Builder timeRanges(InstanceEventWindowTimeRangeRequest ... var1);

        public Builder timeRanges(Consumer<InstanceEventWindowTimeRangeRequest.Builder> ... var1);

        public Builder cronExpression(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

