/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.LockMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LockSnapshotRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, LockSnapshotRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(LockSnapshotRequest.getter(LockSnapshotRequest::snapshotId)).setter(LockSnapshotRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(LockSnapshotRequest.getter(LockSnapshotRequest::dryRun)).setter(LockSnapshotRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> LOCK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockMode").getter(LockSnapshotRequest.getter(LockSnapshotRequest::lockModeAsString)).setter(LockSnapshotRequest.setter(Builder::lockMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockMode").unmarshallLocationName("LockMode").build()}).build();
    private static final SdkField<Integer> COOL_OFF_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CoolOffPeriod").getter(LockSnapshotRequest.getter(LockSnapshotRequest::coolOffPeriod)).setter(LockSnapshotRequest.setter(Builder::coolOffPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriod").unmarshallLocationName("CoolOffPeriod").build()}).build();
    private static final SdkField<Integer> LOCK_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LockDuration").getter(LockSnapshotRequest.getter(LockSnapshotRequest::lockDuration)).setter(LockSnapshotRequest.setter(Builder::lockDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDuration").unmarshallLocationName("LockDuration").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(LockSnapshotRequest.getter(LockSnapshotRequest::expirationDate)).setter(LockSnapshotRequest.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").unmarshallLocationName("ExpirationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, DRY_RUN_FIELD, LOCK_MODE_FIELD, COOL_OFF_PERIOD_FIELD, LOCK_DURATION_FIELD, EXPIRATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnapshotId", SNAPSHOT_ID_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("LockMode", LOCK_MODE_FIELD);
            this.put("CoolOffPeriod", COOL_OFF_PERIOD_FIELD);
            this.put("LockDuration", LOCK_DURATION_FIELD);
            this.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        }
    });
    private final String snapshotId;
    private final Boolean dryRun;
    private final String lockMode;
    private final Integer coolOffPeriod;
    private final Integer lockDuration;
    private final Instant expirationDate;

    private LockSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.dryRun = builder.dryRun;
        this.lockMode = builder.lockMode;
        this.coolOffPeriod = builder.coolOffPeriod;
        this.lockDuration = builder.lockDuration;
        this.expirationDate = builder.expirationDate;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final LockMode lockMode() {
        return LockMode.fromValue(this.lockMode);
    }

    public final String lockModeAsString() {
        return this.lockMode;
    }

    public final Integer coolOffPeriod() {
        return this.coolOffPeriod;
    }

    public final Integer lockDuration() {
        return this.lockDuration;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.coolOffPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockSnapshotRequest)) {
            return false;
        }
        LockSnapshotRequest other = (LockSnapshotRequest)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.lockModeAsString(), other.lockModeAsString()) && Objects.equals(this.coolOffPeriod(), other.coolOffPeriod()) && Objects.equals(this.lockDuration(), other.lockDuration()) && Objects.equals(this.expirationDate(), other.expirationDate());
    }

    public final String toString() {
        return ToString.builder((String)"LockSnapshotRequest").add("SnapshotId", (Object)this.snapshotId()).add("DryRun", (Object)this.dryRun()).add("LockMode", (Object)this.lockModeAsString()).add("CoolOffPeriod", (Object)this.coolOffPeriod()).add("LockDuration", (Object)this.lockDuration()).add("ExpirationDate", (Object)this.expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "LockMode": {
                return Optional.ofNullable(clazz.cast(this.lockModeAsString()));
            }
            case "CoolOffPeriod": {
                return Optional.ofNullable(clazz.cast(this.coolOffPeriod()));
            }
            case "LockDuration": {
                return Optional.ofNullable(clazz.cast(this.lockDuration()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LockSnapshotRequest, T> g) {
        return obj -> g.apply((LockSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String snapshotId;
        private Boolean dryRun;
        private String lockMode;
        private Integer coolOffPeriod;
        private Integer lockDuration;
        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LockSnapshotRequest model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.dryRun(model.dryRun);
            this.lockMode(model.lockMode);
            this.coolOffPeriod(model.coolOffPeriod);
            this.lockDuration(model.lockDuration);
            this.expirationDate(model.expirationDate);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getLockMode() {
            return this.lockMode;
        }

        public final void setLockMode(String lockMode) {
            this.lockMode = lockMode;
        }

        @Override
        public final Builder lockMode(String lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        @Override
        public final Builder lockMode(LockMode lockMode) {
            this.lockMode(lockMode == null ? null : lockMode.toString());
            return this;
        }

        public final Integer getCoolOffPeriod() {
            return this.coolOffPeriod;
        }

        public final void setCoolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
        }

        @Override
        public final Builder coolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
            return this;
        }

        public final Integer getLockDuration() {
            return this.lockDuration;
        }

        public final void setLockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
        }

        @Override
        public final Builder lockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LockSnapshotRequest build() {
            return new LockSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LockSnapshotRequest> {
        public Builder snapshotId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder lockMode(String var1);

        public Builder lockMode(LockMode var1);

        public Builder coolOffPeriod(Integer var1);

        public Builder lockDuration(Integer var1);

        public Builder expirationDate(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

