/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType;
import software.amazon.awssdk.services.ec2.model.IpamComplianceStatus;
import software.amazon.awssdk.services.ec2.model.IpamOverlapStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamAddressHistoryRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamAddressHistoryRecord> {
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceOwnerId)).setter(IpamAddressHistoryRecord.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").unmarshallLocationName("resourceOwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceRegion)).setter(IpamAddressHistoryRecord.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceTypeAsString)).setter(IpamAddressHistoryRecord.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceId)).setter(IpamAddressHistoryRecord.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCidr").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceCidr)).setter(IpamAddressHistoryRecord.setter(Builder::resourceCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr").unmarshallLocationName("resourceCidr").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceName)).setter(IpamAddressHistoryRecord.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").unmarshallLocationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceComplianceStatus").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceComplianceStatusAsString)).setter(IpamAddressHistoryRecord.setter(Builder::resourceComplianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceComplianceStatus").unmarshallLocationName("resourceComplianceStatus").build()}).build();
    private static final SdkField<String> RESOURCE_OVERLAP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOverlapStatus").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::resourceOverlapStatusAsString)).setter(IpamAddressHistoryRecord.setter(Builder::resourceOverlapStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOverlapStatus").unmarshallLocationName("resourceOverlapStatus").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::vpcId)).setter(IpamAddressHistoryRecord.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<Instant> SAMPLED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampledStartTime").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::sampledStartTime)).setter(IpamAddressHistoryRecord.setter(Builder::sampledStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledStartTime").unmarshallLocationName("sampledStartTime").build()}).build();
    private static final SdkField<Instant> SAMPLED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampledEndTime").getter(IpamAddressHistoryRecord.getter(IpamAddressHistoryRecord::sampledEndTime)).setter(IpamAddressHistoryRecord.setter(Builder::sampledEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledEndTime").unmarshallLocationName("sampledEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_OWNER_ID_FIELD, RESOURCE_REGION_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_CIDR_FIELD, RESOURCE_NAME_FIELD, RESOURCE_COMPLIANCE_STATUS_FIELD, RESOURCE_OVERLAP_STATUS_FIELD, VPC_ID_FIELD, SAMPLED_START_TIME_FIELD, SAMPLED_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceOwnerId", RESOURCE_OWNER_ID_FIELD);
            this.put("ResourceRegion", RESOURCE_REGION_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ResourceCidr", RESOURCE_CIDR_FIELD);
            this.put("ResourceName", RESOURCE_NAME_FIELD);
            this.put("ResourceComplianceStatus", RESOURCE_COMPLIANCE_STATUS_FIELD);
            this.put("ResourceOverlapStatus", RESOURCE_OVERLAP_STATUS_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("SampledStartTime", SAMPLED_START_TIME_FIELD);
            this.put("SampledEndTime", SAMPLED_END_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceOwnerId;
    private final String resourceRegion;
    private final String resourceType;
    private final String resourceId;
    private final String resourceCidr;
    private final String resourceName;
    private final String resourceComplianceStatus;
    private final String resourceOverlapStatus;
    private final String vpcId;
    private final Instant sampledStartTime;
    private final Instant sampledEndTime;

    private IpamAddressHistoryRecord(BuilderImpl builder) {
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceRegion = builder.resourceRegion;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceCidr = builder.resourceCidr;
        this.resourceName = builder.resourceName;
        this.resourceComplianceStatus = builder.resourceComplianceStatus;
        this.resourceOverlapStatus = builder.resourceOverlapStatus;
        this.vpcId = builder.vpcId;
        this.sampledStartTime = builder.sampledStartTime;
        this.sampledEndTime = builder.sampledEndTime;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final IpamAddressHistoryResourceType resourceType() {
        return IpamAddressHistoryResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceCidr() {
        return this.resourceCidr;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final IpamComplianceStatus resourceComplianceStatus() {
        return IpamComplianceStatus.fromValue(this.resourceComplianceStatus);
    }

    public final String resourceComplianceStatusAsString() {
        return this.resourceComplianceStatus;
    }

    public final IpamOverlapStatus resourceOverlapStatus() {
        return IpamOverlapStatus.fromValue(this.resourceOverlapStatus);
    }

    public final String resourceOverlapStatusAsString() {
        return this.resourceOverlapStatus;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Instant sampledStartTime() {
        return this.sampledStartTime;
    }

    public final Instant sampledEndTime() {
        return this.sampledEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceComplianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOverlapStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampledEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamAddressHistoryRecord)) {
            return false;
        }
        IpamAddressHistoryRecord other = (IpamAddressHistoryRecord)obj;
        return Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceCidr(), other.resourceCidr()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceComplianceStatusAsString(), other.resourceComplianceStatusAsString()) && Objects.equals(this.resourceOverlapStatusAsString(), other.resourceOverlapStatusAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.sampledStartTime(), other.sampledStartTime()) && Objects.equals(this.sampledEndTime(), other.sampledEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"IpamAddressHistoryRecord").add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceCidr", (Object)this.resourceCidr()).add("ResourceName", (Object)this.resourceName()).add("ResourceComplianceStatus", (Object)this.resourceComplianceStatusAsString()).add("ResourceOverlapStatus", (Object)this.resourceOverlapStatusAsString()).add("VpcId", (Object)this.vpcId()).add("SampledStartTime", (Object)this.sampledStartTime()).add("SampledEndTime", (Object)this.sampledEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceCidr": {
                return Optional.ofNullable(clazz.cast(this.resourceCidr()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ResourceComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceComplianceStatusAsString()));
            }
            case "ResourceOverlapStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceOverlapStatusAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SampledStartTime": {
                return Optional.ofNullable(clazz.cast(this.sampledStartTime()));
            }
            case "SampledEndTime": {
                return Optional.ofNullable(clazz.cast(this.sampledEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamAddressHistoryRecord, T> g) {
        return obj -> g.apply((IpamAddressHistoryRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceOwnerId;
        private String resourceRegion;
        private String resourceType;
        private String resourceId;
        private String resourceCidr;
        private String resourceName;
        private String resourceComplianceStatus;
        private String resourceOverlapStatus;
        private String vpcId;
        private Instant sampledStartTime;
        private Instant sampledEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamAddressHistoryRecord model) {
            this.resourceOwnerId(model.resourceOwnerId);
            this.resourceRegion(model.resourceRegion);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceCidr(model.resourceCidr);
            this.resourceName(model.resourceName);
            this.resourceComplianceStatus(model.resourceComplianceStatus);
            this.resourceOverlapStatus(model.resourceOverlapStatus);
            this.vpcId(model.vpcId);
            this.sampledStartTime(model.sampledStartTime);
            this.sampledEndTime(model.sampledEndTime);
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamAddressHistoryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceCidr() {
            return this.resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceComplianceStatus() {
            return this.resourceComplianceStatus;
        }

        public final void setResourceComplianceStatus(String resourceComplianceStatus) {
            this.resourceComplianceStatus = resourceComplianceStatus;
        }

        @Override
        public final Builder resourceComplianceStatus(String resourceComplianceStatus) {
            this.resourceComplianceStatus = resourceComplianceStatus;
            return this;
        }

        @Override
        public final Builder resourceComplianceStatus(IpamComplianceStatus resourceComplianceStatus) {
            this.resourceComplianceStatus(resourceComplianceStatus == null ? null : resourceComplianceStatus.toString());
            return this;
        }

        public final String getResourceOverlapStatus() {
            return this.resourceOverlapStatus;
        }

        public final void setResourceOverlapStatus(String resourceOverlapStatus) {
            this.resourceOverlapStatus = resourceOverlapStatus;
        }

        @Override
        public final Builder resourceOverlapStatus(String resourceOverlapStatus) {
            this.resourceOverlapStatus = resourceOverlapStatus;
            return this;
        }

        @Override
        public final Builder resourceOverlapStatus(IpamOverlapStatus resourceOverlapStatus) {
            this.resourceOverlapStatus(resourceOverlapStatus == null ? null : resourceOverlapStatus.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Instant getSampledStartTime() {
            return this.sampledStartTime;
        }

        public final void setSampledStartTime(Instant sampledStartTime) {
            this.sampledStartTime = sampledStartTime;
        }

        @Override
        public final Builder sampledStartTime(Instant sampledStartTime) {
            this.sampledStartTime = sampledStartTime;
            return this;
        }

        public final Instant getSampledEndTime() {
            return this.sampledEndTime;
        }

        public final void setSampledEndTime(Instant sampledEndTime) {
            this.sampledEndTime = sampledEndTime;
        }

        @Override
        public final Builder sampledEndTime(Instant sampledEndTime) {
            this.sampledEndTime = sampledEndTime;
            return this;
        }

        public IpamAddressHistoryRecord build() {
            return new IpamAddressHistoryRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamAddressHistoryRecord> {
        public Builder resourceOwnerId(String var1);

        public Builder resourceRegion(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamAddressHistoryResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceCidr(String var1);

        public Builder resourceName(String var1);

        public Builder resourceComplianceStatus(String var1);

        public Builder resourceComplianceStatus(IpamComplianceStatus var1);

        public Builder resourceOverlapStatus(String var1);

        public Builder resourceOverlapStatus(IpamOverlapStatus var1);

        public Builder vpcId(String var1);

        public Builder sampledStartTime(Instant var1);

        public Builder sampledEndTime(Instant var1);
    }
}

