/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TargetNetwork;
import software.amazon.awssdk.services.ec2.model.TargetNetworkSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientVpnTargetNetworksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeClientVpnTargetNetworksResponse> {
    private static final SdkField<List<TargetNetwork>> CLIENT_VPN_TARGET_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientVpnTargetNetworks").getter(DescribeClientVpnTargetNetworksResponse.getter(DescribeClientVpnTargetNetworksResponse::clientVpnTargetNetworks)).setter(DescribeClientVpnTargetNetworksResponse.setter(Builder::clientVpnTargetNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnTargetNetworks").unmarshallLocationName("clientVpnTargetNetworks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClientVpnTargetNetworksResponse.getter(DescribeClientVpnTargetNetworksResponse::nextToken)).setter(DescribeClientVpnTargetNetworksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_TARGET_NETWORKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientVpnTargetNetworks", CLIENT_VPN_TARGET_NETWORKS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TargetNetwork> clientVpnTargetNetworks;
    private final String nextToken;

    private DescribeClientVpnTargetNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnTargetNetworks = builder.clientVpnTargetNetworks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClientVpnTargetNetworks() {
        return this.clientVpnTargetNetworks != null && !(this.clientVpnTargetNetworks instanceof SdkAutoConstructList);
    }

    public final List<TargetNetwork> clientVpnTargetNetworks() {
        return this.clientVpnTargetNetworks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientVpnTargetNetworks() ? this.clientVpnTargetNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnTargetNetworksResponse)) {
            return false;
        }
        DescribeClientVpnTargetNetworksResponse other = (DescribeClientVpnTargetNetworksResponse)((Object)obj);
        return this.hasClientVpnTargetNetworks() == other.hasClientVpnTargetNetworks() && Objects.equals(this.clientVpnTargetNetworks(), other.clientVpnTargetNetworks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClientVpnTargetNetworksResponse").add("ClientVpnTargetNetworks", this.hasClientVpnTargetNetworks() ? this.clientVpnTargetNetworks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnTargetNetworks": {
                return Optional.ofNullable(clazz.cast(this.clientVpnTargetNetworks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnTargetNetworksResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnTargetNetworksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TargetNetwork> clientVpnTargetNetworks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnTargetNetworksResponse model) {
            super(model);
            this.clientVpnTargetNetworks(model.clientVpnTargetNetworks);
            this.nextToken(model.nextToken);
        }

        public final List<TargetNetwork.Builder> getClientVpnTargetNetworks() {
            List<TargetNetwork.Builder> result = TargetNetworkSetCopier.copyToBuilder(this.clientVpnTargetNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientVpnTargetNetworks(Collection<TargetNetwork.BuilderImpl> clientVpnTargetNetworks) {
            this.clientVpnTargetNetworks = TargetNetworkSetCopier.copyFromBuilder(clientVpnTargetNetworks);
        }

        @Override
        public final Builder clientVpnTargetNetworks(Collection<TargetNetwork> clientVpnTargetNetworks) {
            this.clientVpnTargetNetworks = TargetNetworkSetCopier.copy(clientVpnTargetNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnTargetNetworks(TargetNetwork ... clientVpnTargetNetworks) {
            this.clientVpnTargetNetworks(Arrays.asList(clientVpnTargetNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnTargetNetworks(Consumer<TargetNetwork.Builder> ... clientVpnTargetNetworks) {
            this.clientVpnTargetNetworks(Stream.of(clientVpnTargetNetworks).map(c -> (TargetNetwork)((TargetNetwork.Builder)TargetNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClientVpnTargetNetworksResponse build() {
            return new DescribeClientVpnTargetNetworksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientVpnTargetNetworksResponse> {
        public Builder clientVpnTargetNetworks(Collection<TargetNetwork> var1);

        public Builder clientVpnTargetNetworks(TargetNetwork ... var1);

        public Builder clientVpnTargetNetworks(Consumer<TargetNetwork.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

