/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPool;
import software.amazon.awssdk.services.ec2.model.IpamPoolSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamPoolsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamPoolsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamPoolsResponse.getter(DescribeIpamPoolsResponse::nextToken)).setter(DescribeIpamPoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamPool>> IPAM_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamPools").getter(DescribeIpamPoolsResponse.getter(DescribeIpamPoolsResponse::ipamPools)).setter(DescribeIpamPoolsResponse.setter(Builder::ipamPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolSet").unmarshallLocationName("ipamPoolSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_POOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("IpamPoolSet", IPAM_POOLS_FIELD);
        }
    });
    private final String nextToken;
    private final List<IpamPool> ipamPools;

    private DescribeIpamPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamPools = builder.ipamPools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamPools() {
        return this.ipamPools != null && !(this.ipamPools instanceof SdkAutoConstructList);
    }

    public final List<IpamPool> ipamPools() {
        return this.ipamPools;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamPools() ? this.ipamPools() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamPoolsResponse)) {
            return false;
        }
        DescribeIpamPoolsResponse other = (DescribeIpamPoolsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamPools() == other.hasIpamPools() && Objects.equals(this.ipamPools(), other.ipamPools());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamPoolsResponse").add("NextToken", (Object)this.nextToken()).add("IpamPools", this.hasIpamPools() ? this.ipamPools() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamPools": {
                return Optional.ofNullable(clazz.cast(this.ipamPools()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamPoolsResponse, T> g) {
        return obj -> g.apply((DescribeIpamPoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamPool> ipamPools = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamPoolsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamPools(model.ipamPools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamPool.Builder> getIpamPools() {
            List<IpamPool.Builder> result = IpamPoolSetCopier.copyToBuilder(this.ipamPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPools(Collection<IpamPool.BuilderImpl> ipamPools) {
            this.ipamPools = IpamPoolSetCopier.copyFromBuilder(ipamPools);
        }

        @Override
        public final Builder ipamPools(Collection<IpamPool> ipamPools) {
            this.ipamPools = IpamPoolSetCopier.copy(ipamPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPools(IpamPool ... ipamPools) {
            this.ipamPools(Arrays.asList(ipamPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPools(Consumer<IpamPool.Builder> ... ipamPools) {
            this.ipamPools(Stream.of(ipamPools).map(c -> (IpamPool)((IpamPool.Builder)IpamPool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamPoolsResponse build() {
            return new DescribeIpamPoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamPoolsResponse> {
        public Builder nextToken(String var1);

        public Builder ipamPools(Collection<IpamPool> var1);

        public Builder ipamPools(IpamPool ... var1);

        public Builder ipamPools(Consumer<IpamPool.Builder> ... var1);
    }
}

