/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PriceScheduleSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PriceScheduleSpecification> {
    private static final SdkField<Long> TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Term").getter(PriceScheduleSpecification.getter(PriceScheduleSpecification::term)).setter(PriceScheduleSpecification.setter(Builder::term)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Term").unmarshallLocationName("term").build()}).build();
    private static final SdkField<Double> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Price").getter(PriceScheduleSpecification.getter(PriceScheduleSpecification::price)).setter(PriceScheduleSpecification.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price").unmarshallLocationName("price").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(PriceScheduleSpecification.getter(PriceScheduleSpecification::currencyCodeAsString)).setter(PriceScheduleSpecification.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERM_FIELD, PRICE_FIELD, CURRENCY_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long term;
    private final Double price;
    private final String currencyCode;

    private PriceScheduleSpecification(BuilderImpl builder) {
        this.term = builder.term;
        this.price = builder.price;
        this.currencyCode = builder.currencyCode;
    }

    public final Long term() {
        return this.term;
    }

    public final Double price() {
        return this.price;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.term());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceScheduleSpecification)) {
            return false;
        }
        PriceScheduleSpecification other = (PriceScheduleSpecification)obj;
        return Objects.equals(this.term(), other.term()) && Objects.equals(this.price(), other.price()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PriceScheduleSpecification").add("Term", (Object)this.term()).add("Price", (Object)this.price()).add("CurrencyCode", (Object)this.currencyCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Term": {
                return Optional.ofNullable(clazz.cast(this.term()));
            }
            case "Price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PriceScheduleSpecification, T> g) {
        return obj -> g.apply((PriceScheduleSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long term;
        private Double price;
        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceScheduleSpecification model) {
            this.term(model.term);
            this.price(model.price);
            this.currencyCode(model.currencyCode);
        }

        public final Long getTerm() {
            return this.term;
        }

        public final void setTerm(Long term) {
            this.term = term;
        }

        @Override
        public final Builder term(Long term) {
            this.term = term;
            return this;
        }

        public final Double getPrice() {
            return this.price;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public PriceScheduleSpecification build() {
            return new PriceScheduleSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PriceScheduleSpecification> {
        public Builder term(Long var1);

        public Builder price(Double var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);
    }
}

