/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVerifiedAccessGroupPolicyRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetVerifiedAccessGroupPolicyRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(GetVerifiedAccessGroupPolicyRequest.getter(GetVerifiedAccessGroupPolicyRequest::verifiedAccessGroupId)).setter(GetVerifiedAccessGroupPolicyRequest.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("VerifiedAccessGroupId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetVerifiedAccessGroupPolicyRequest.getter(GetVerifiedAccessGroupPolicyRequest::dryRun)).setter(GetVerifiedAccessGroupPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUP_ID_FIELD, DRY_RUN_FIELD));
    private final String verifiedAccessGroupId;
    private final Boolean dryRun;

    private GetVerifiedAccessGroupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.dryRun = builder.dryRun;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVerifiedAccessGroupPolicyRequest)) {
            return false;
        }
        GetVerifiedAccessGroupPolicyRequest other = (GetVerifiedAccessGroupPolicyRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"GetVerifiedAccessGroupPolicyRequest").add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVerifiedAccessGroupPolicyRequest, T> g) {
        return obj -> g.apply((GetVerifiedAccessGroupPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessGroupId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVerifiedAccessGroupPolicyRequest model) {
            super(model);
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.dryRun(model.dryRun);
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVerifiedAccessGroupPolicyRequest build() {
            return new GetVerifiedAccessGroupPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVerifiedAccessGroupPolicyRequest> {
        public Builder verifiedAccessGroupId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

