/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInterface;

public class DescribeNetworkInterfacesIterable
implements SdkIterable<DescribeNetworkInterfacesResponse> {
    private final Ec2Client client;
    private final DescribeNetworkInterfacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNetworkInterfacesIterable(Ec2Client client, DescribeNetworkInterfacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNetworkInterfacesResponseFetcher();
    }

    public Iterator<DescribeNetworkInterfacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkInterface> networkInterfaces() {
        Function<DescribeNetworkInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInterfaces() != null) {
                return response.networkInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNetworkInterfacesResponseFetcher
    implements SyncPageFetcher<DescribeNetworkInterfacesResponse> {
        private DescribeNetworkInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNetworkInterfacesResponse nextPage(DescribeNetworkInterfacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInterfacesIterable.this.client.describeNetworkInterfaces(DescribeNetworkInterfacesIterable.this.firstRequest);
            }
            return DescribeNetworkInterfacesIterable.this.client.describeNetworkInterfaces((DescribeNetworkInterfacesRequest)((Object)DescribeNetworkInterfacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

