/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensedListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessInstance> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::verifiedAccessInstanceId)).setter(VerifiedAccessInstance.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("verifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::description)).setter(VerifiedAccessInstance.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<VerifiedAccessTrustProviderCondensed>> VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedAccessTrustProviders").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::verifiedAccessTrustProviders)).setter(VerifiedAccessInstance.setter(Builder::verifiedAccessTrustProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderSet").unmarshallLocationName("verifiedAccessTrustProviderSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessTrustProviderCondensed::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::creationTime)).setter(VerifiedAccessInstance.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTime").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::lastUpdatedTime)).setter(VerifiedAccessInstance.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").unmarshallLocationName("lastUpdatedTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::tags)).setter(VerifiedAccessInstance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FIPS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FipsEnabled").getter(VerifiedAccessInstance.getter(VerifiedAccessInstance::fipsEnabled)).setter(VerifiedAccessInstance.setter(Builder::fipsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FipsEnabled").unmarshallLocationName("fipsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_INSTANCE_ID_FIELD, DESCRIPTION_FIELD, VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, TAGS_FIELD, FIPS_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String verifiedAccessInstanceId;
    private final String description;
    private final List<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders;
    private final String creationTime;
    private final String lastUpdatedTime;
    private final List<Tag> tags;
    private final Boolean fipsEnabled;

    private VerifiedAccessInstance(BuilderImpl builder) {
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.description = builder.description;
        this.verifiedAccessTrustProviders = builder.verifiedAccessTrustProviders;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.tags = builder.tags;
        this.fipsEnabled = builder.fipsEnabled;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasVerifiedAccessTrustProviders() {
        return this.verifiedAccessTrustProviders != null && !(this.verifiedAccessTrustProviders instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders() {
        return this.verifiedAccessTrustProviders;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean fipsEnabled() {
        return this.fipsEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedAccessTrustProviders() ? this.verifiedAccessTrustProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fipsEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstance)) {
            return false;
        }
        VerifiedAccessInstance other = (VerifiedAccessInstance)obj;
        return Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.description(), other.description()) && this.hasVerifiedAccessTrustProviders() == other.hasVerifiedAccessTrustProviders() && Objects.equals(this.verifiedAccessTrustProviders(), other.verifiedAccessTrustProviders()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fipsEnabled(), other.fipsEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessInstance").add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("Description", (Object)this.description()).add("VerifiedAccessTrustProviders", this.hasVerifiedAccessTrustProviders() ? this.verifiedAccessTrustProviders() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Tags", this.hasTags() ? this.tags() : null).add("FipsEnabled", (Object)this.fipsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VerifiedAccessTrustProviders": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessTrustProviders()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FipsEnabled": {
                return Optional.ofNullable(clazz.cast(this.fipsEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstance, T> g) {
        return obj -> g.apply((VerifiedAccessInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String verifiedAccessInstanceId;
        private String description;
        private List<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders = DefaultSdkAutoConstructList.getInstance();
        private String creationTime;
        private String lastUpdatedTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean fipsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstance model) {
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.description(model.description);
            this.verifiedAccessTrustProviders(model.verifiedAccessTrustProviders);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.tags(model.tags);
            this.fipsEnabled(model.fipsEnabled);
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<VerifiedAccessTrustProviderCondensed.Builder> getVerifiedAccessTrustProviders() {
            List<VerifiedAccessTrustProviderCondensed.Builder> result = VerifiedAccessTrustProviderCondensedListCopier.copyToBuilder(this.verifiedAccessTrustProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessTrustProviders(Collection<VerifiedAccessTrustProviderCondensed.BuilderImpl> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = VerifiedAccessTrustProviderCondensedListCopier.copyFromBuilder(verifiedAccessTrustProviders);
        }

        @Override
        public final Builder verifiedAccessTrustProviders(Collection<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = VerifiedAccessTrustProviderCondensedListCopier.copy(verifiedAccessTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessTrustProviders(VerifiedAccessTrustProviderCondensed ... verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders(Arrays.asList(verifiedAccessTrustProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessTrustProviders(Consumer<VerifiedAccessTrustProviderCondensed.Builder> ... verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders(Stream.of(verifiedAccessTrustProviders).map(c -> (VerifiedAccessTrustProviderCondensed)((VerifiedAccessTrustProviderCondensed.Builder)VerifiedAccessTrustProviderCondensed.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getFipsEnabled() {
            return this.fipsEnabled;
        }

        public final void setFipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
        }

        @Override
        public final Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        public VerifiedAccessInstance build() {
            return new VerifiedAccessInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessInstance> {
        public Builder verifiedAccessInstanceId(String var1);

        public Builder description(String var1);

        public Builder verifiedAccessTrustProviders(Collection<VerifiedAccessTrustProviderCondensed> var1);

        public Builder verifiedAccessTrustProviders(VerifiedAccessTrustProviderCondensed ... var1);

        public Builder verifiedAccessTrustProviders(Consumer<VerifiedAccessTrustProviderCondensed.Builder> ... var1);

        public Builder creationTime(String var1);

        public Builder lastUpdatedTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder fipsEnabled(Boolean var1);
    }
}

