/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ExportImageTask;
import software.amazon.awssdk.services.ec2.model.ExportImageTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportImageTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeExportImageTasksResponse> {
    private static final SdkField<List<ExportImageTask>> EXPORT_IMAGE_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportImageTasks").getter(DescribeExportImageTasksResponse.getter(DescribeExportImageTasksResponse::exportImageTasks)).setter(DescribeExportImageTasksResponse.setter(Builder::exportImageTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskSet").unmarshallLocationName("exportImageTaskSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportImageTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeExportImageTasksResponse.getter(DescribeExportImageTasksResponse::nextToken)).setter(DescribeExportImageTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_IMAGE_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExportImageTask> exportImageTasks;
    private final String nextToken;

    private DescribeExportImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportImageTasks = builder.exportImageTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExportImageTasks() {
        return this.exportImageTasks != null && !(this.exportImageTasks instanceof SdkAutoConstructList);
    }

    public final List<ExportImageTask> exportImageTasks() {
        return this.exportImageTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportImageTasks() ? this.exportImageTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportImageTasksResponse)) {
            return false;
        }
        DescribeExportImageTasksResponse other = (DescribeExportImageTasksResponse)((Object)obj);
        return this.hasExportImageTasks() == other.hasExportImageTasks() && Objects.equals(this.exportImageTasks(), other.exportImageTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExportImageTasksResponse").add("ExportImageTasks", this.hasExportImageTasks() ? this.exportImageTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportImageTasks": {
                return Optional.ofNullable(clazz.cast(this.exportImageTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportImageTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportImageTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ExportImageTask> exportImageTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportImageTasksResponse model) {
            super(model);
            this.exportImageTasks(model.exportImageTasks);
            this.nextToken(model.nextToken);
        }

        public final List<ExportImageTask.Builder> getExportImageTasks() {
            List<ExportImageTask.Builder> result = ExportImageTaskListCopier.copyToBuilder(this.exportImageTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportImageTasks(Collection<ExportImageTask.BuilderImpl> exportImageTasks) {
            this.exportImageTasks = ExportImageTaskListCopier.copyFromBuilder(exportImageTasks);
        }

        @Override
        public final Builder exportImageTasks(Collection<ExportImageTask> exportImageTasks) {
            this.exportImageTasks = ExportImageTaskListCopier.copy(exportImageTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportImageTasks(ExportImageTask ... exportImageTasks) {
            this.exportImageTasks(Arrays.asList(exportImageTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportImageTasks(Consumer<ExportImageTask.Builder> ... exportImageTasks) {
            this.exportImageTasks(Stream.of(exportImageTasks).map(c -> (ExportImageTask)((ExportImageTask.Builder)ExportImageTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeExportImageTasksResponse build() {
            return new DescribeExportImageTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExportImageTasksResponse> {
        public Builder exportImageTasks(Collection<ExportImageTask> var1);

        public Builder exportImageTasks(ExportImageTask ... var1);

        public Builder exportImageTasks(Consumer<ExportImageTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

