/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListAttachment;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayPrefixListReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayPrefixListReference> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableId").getter(TransitGatewayPrefixListReference.getter(TransitGatewayPrefixListReference::transitGatewayRouteTableId)).setter(TransitGatewayPrefixListReference.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("transitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(TransitGatewayPrefixListReference.getter(TransitGatewayPrefixListReference::prefixListId)).setter(TransitGatewayPrefixListReference.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("prefixListId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListOwnerId").getter(TransitGatewayPrefixListReference.getter(TransitGatewayPrefixListReference::prefixListOwnerId)).setter(TransitGatewayPrefixListReference.setter(Builder::prefixListOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListOwnerId").unmarshallLocationName("prefixListOwnerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayPrefixListReference.getter(TransitGatewayPrefixListReference::stateAsString)).setter(TransitGatewayPrefixListReference.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Boolean> BLACKHOLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Blackhole").getter(TransitGatewayPrefixListReference.getter(TransitGatewayPrefixListReference::blackhole)).setter(TransitGatewayPrefixListReference.setter(Builder::blackhole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blackhole").unmarshallLocationName("blackhole").build()}).build();
    private static final SdkField<TransitGatewayPrefixListAttachment> TRANSIT_GATEWAY_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGatewayAttachment").getter(TransitGatewayPrefixListReference.getter(TransitGatewayPrefixListReference::transitGatewayAttachment)).setter(TransitGatewayPrefixListReference.setter(Builder::transitGatewayAttachment)).constructor(TransitGatewayPrefixListAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachment").unmarshallLocationName("transitGatewayAttachment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_OWNER_ID_FIELD, STATE_FIELD, BLACKHOLE_FIELD, TRANSIT_GATEWAY_ATTACHMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayRouteTableId;
    private final String prefixListId;
    private final String prefixListOwnerId;
    private final String state;
    private final Boolean blackhole;
    private final TransitGatewayPrefixListAttachment transitGatewayAttachment;

    private TransitGatewayPrefixListReference(BuilderImpl builder) {
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.prefixListId = builder.prefixListId;
        this.prefixListOwnerId = builder.prefixListOwnerId;
        this.state = builder.state;
        this.blackhole = builder.blackhole;
        this.transitGatewayAttachment = builder.transitGatewayAttachment;
    }

    public final String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String prefixListOwnerId() {
        return this.prefixListOwnerId;
    }

    public final TransitGatewayPrefixListReferenceState state() {
        return TransitGatewayPrefixListReferenceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Boolean blackhole() {
        return this.blackhole;
    }

    public final TransitGatewayPrefixListAttachment transitGatewayAttachment() {
        return this.transitGatewayAttachment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blackhole());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPrefixListReference)) {
            return false;
        }
        TransitGatewayPrefixListReference other = (TransitGatewayPrefixListReference)obj;
        return Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.prefixListOwnerId(), other.prefixListOwnerId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.blackhole(), other.blackhole()) && Objects.equals(this.transitGatewayAttachment(), other.transitGatewayAttachment());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayPrefixListReference").add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("PrefixListId", (Object)this.prefixListId()).add("PrefixListOwnerId", (Object)this.prefixListOwnerId()).add("State", (Object)this.stateAsString()).add("Blackhole", (Object)this.blackhole()).add("TransitGatewayAttachment", (Object)this.transitGatewayAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "PrefixListOwnerId": {
                return Optional.ofNullable(clazz.cast(this.prefixListOwnerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Blackhole": {
                return Optional.ofNullable(clazz.cast(this.blackhole()));
            }
            case "TransitGatewayAttachment": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPrefixListReference, T> g) {
        return obj -> g.apply((TransitGatewayPrefixListReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayRouteTableId;
        private String prefixListId;
        private String prefixListOwnerId;
        private String state;
        private Boolean blackhole;
        private TransitGatewayPrefixListAttachment transitGatewayAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPrefixListReference model) {
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.prefixListId(model.prefixListId);
            this.prefixListOwnerId(model.prefixListOwnerId);
            this.state(model.state);
            this.blackhole(model.blackhole);
            this.transitGatewayAttachment(model.transitGatewayAttachment);
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListOwnerId() {
            return this.prefixListOwnerId;
        }

        public final void setPrefixListOwnerId(String prefixListOwnerId) {
            this.prefixListOwnerId = prefixListOwnerId;
        }

        @Override
        public final Builder prefixListOwnerId(String prefixListOwnerId) {
            this.prefixListOwnerId = prefixListOwnerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayPrefixListReferenceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getBlackhole() {
            return this.blackhole;
        }

        public final void setBlackhole(Boolean blackhole) {
            this.blackhole = blackhole;
        }

        @Override
        public final Builder blackhole(Boolean blackhole) {
            this.blackhole = blackhole;
            return this;
        }

        public final TransitGatewayPrefixListAttachment.Builder getTransitGatewayAttachment() {
            return this.transitGatewayAttachment != null ? this.transitGatewayAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayAttachment(TransitGatewayPrefixListAttachment.BuilderImpl transitGatewayAttachment) {
            this.transitGatewayAttachment = transitGatewayAttachment != null ? transitGatewayAttachment.build() : null;
        }

        @Override
        public final Builder transitGatewayAttachment(TransitGatewayPrefixListAttachment transitGatewayAttachment) {
            this.transitGatewayAttachment = transitGatewayAttachment;
            return this;
        }

        public TransitGatewayPrefixListReference build() {
            return new TransitGatewayPrefixListReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayPrefixListReference> {
        public Builder transitGatewayRouteTableId(String var1);

        public Builder prefixListId(String var1);

        public Builder prefixListOwnerId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayPrefixListReferenceState var1);

        public Builder blackhole(Boolean var1);

        public Builder transitGatewayAttachment(TransitGatewayPrefixListAttachment var1);

        default public Builder transitGatewayAttachment(Consumer<TransitGatewayPrefixListAttachment.Builder> transitGatewayAttachment) {
            return this.transitGatewayAttachment((TransitGatewayPrefixListAttachment)((TransitGatewayPrefixListAttachment.Builder)TransitGatewayPrefixListAttachment.builder().applyMutation(transitGatewayAttachment)).build());
        }
    }
}

