/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.MetricType;
import software.amazon.awssdk.services.ec2.model.PeriodType;
import software.amazon.awssdk.services.ec2.model.StatisticType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DataQuery.getter(DataQuery::id)).setter(DataQuery.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DataQuery.getter(DataQuery::source)).setter(DataQuery.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("Source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(DataQuery.getter(DataQuery::destination)).setter(DataQuery.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("Destination").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(DataQuery.getter(DataQuery::metricAsString)).setter(DataQuery.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").unmarshallLocationName("Metric").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(DataQuery.getter(DataQuery::statisticAsString)).setter(DataQuery.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").unmarshallLocationName("Statistic").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Period").getter(DataQuery.getter(DataQuery::periodAsString)).setter(DataQuery.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").unmarshallLocationName("Period").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SOURCE_FIELD, DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD, PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String source;
    private final String destination;
    private final String metric;
    private final String statistic;
    private final String period;

    private DataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
        this.period = builder.period;
    }

    public final String id() {
        return this.id;
    }

    public final String source() {
        return this.source;
    }

    public final String destination() {
        return this.destination;
    }

    public final MetricType metric() {
        return MetricType.fromValue(this.metric);
    }

    public final String metricAsString() {
        return this.metric;
    }

    public final StatisticType statistic() {
        return StatisticType.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final PeriodType period() {
        return PeriodType.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQuery)) {
            return false;
        }
        DataQuery other = (DataQuery)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.metricAsString(), other.metricAsString()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.periodAsString(), other.periodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataQuery").add("Id", (Object)this.id()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("Metric", (Object)this.metricAsString()).add("Statistic", (Object)this.statisticAsString()).add("Period", (Object)this.periodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metricAsString()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQuery, T> g) {
        return obj -> g.apply((DataQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String source;
        private String destination;
        private String metric;
        private String statistic;
        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQuery model) {
            this.id(model.id);
            this.source(model.source);
            this.destination(model.destination);
            this.metric(model.metric);
            this.statistic(model.statistic);
            this.period(model.period);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(PeriodType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public DataQuery build() {
            return new DataQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQuery> {
        public Builder id(String var1);

        public Builder source(String var1);

        public Builder destination(String var1);

        public Builder metric(String var1);

        public Builder metric(MetricType var1);

        public Builder statistic(String var1);

        public Builder statistic(StatisticType var1);

        public Builder period(String var1);

        public Builder period(PeriodType var1);
    }
}

