/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement;

public class DescribeTransitGatewayRouteTableAnnouncementsIterable
implements SdkIterable<DescribeTransitGatewayRouteTableAnnouncementsResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayRouteTableAnnouncementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayRouteTableAnnouncementsIterable(Ec2Client client, DescribeTransitGatewayRouteTableAnnouncementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTransitGatewayRouteTableAnnouncementsResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayRouteTableAnnouncementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayRouteTableAnnouncement> transitGatewayRouteTableAnnouncements() {
        Function<DescribeTransitGatewayRouteTableAnnouncementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayRouteTableAnnouncements() != null) {
                return response.transitGatewayRouteTableAnnouncements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayRouteTableAnnouncementsResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayRouteTableAnnouncementsResponse> {
        private DescribeTransitGatewayRouteTableAnnouncementsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayRouteTableAnnouncementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayRouteTableAnnouncementsResponse nextPage(DescribeTransitGatewayRouteTableAnnouncementsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayRouteTableAnnouncementsIterable.this.client.describeTransitGatewayRouteTableAnnouncements(DescribeTransitGatewayRouteTableAnnouncementsIterable.this.firstRequest);
            }
            return DescribeTransitGatewayRouteTableAnnouncementsIterable.this.client.describeTransitGatewayRouteTableAnnouncements((DescribeTransitGatewayRouteTableAnnouncementsRequest)((Object)DescribeTransitGatewayRouteTableAnnouncementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

