/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessLogOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessInstanceLoggingConfigurationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessInstanceLoggingConfigurationRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest::verifiedAccessInstanceId)).setter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("VerifiedAccessInstanceId").build()}).build();
    private static final SdkField<VerifiedAccessLogOptions> ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLogs").getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest::accessLogs)).setter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.setter(Builder::accessLogs)).constructor(VerifiedAccessLogOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLogs").unmarshallLocationName("AccessLogs").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest::dryRun)).setter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.getter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest::clientToken)).setter(ModifyVerifiedAccessInstanceLoggingConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_INSTANCE_ID_FIELD, ACCESS_LOGS_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD));
    private final String verifiedAccessInstanceId;
    private final VerifiedAccessLogOptions accessLogs;
    private final Boolean dryRun;
    private final String clientToken;

    private ModifyVerifiedAccessInstanceLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.accessLogs = builder.accessLogs;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final VerifiedAccessLogOptions accessLogs() {
        return this.accessLogs;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessInstanceLoggingConfigurationRequest)) {
            return false;
        }
        ModifyVerifiedAccessInstanceLoggingConfigurationRequest other = (ModifyVerifiedAccessInstanceLoggingConfigurationRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.accessLogs(), other.accessLogs()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessInstanceLoggingConfigurationRequest").add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("AccessLogs", (Object)this.accessLogs()).add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "AccessLogs": {
                return Optional.ofNullable(clazz.cast(this.accessLogs()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessInstanceLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessInstanceLoggingConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessInstanceId;
        private VerifiedAccessLogOptions accessLogs;
        private Boolean dryRun;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessInstanceLoggingConfigurationRequest model) {
            super(model);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.accessLogs(model.accessLogs);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final VerifiedAccessLogOptions.Builder getAccessLogs() {
            return this.accessLogs != null ? this.accessLogs.toBuilder() : null;
        }

        public final void setAccessLogs(VerifiedAccessLogOptions.BuilderImpl accessLogs) {
            this.accessLogs = accessLogs != null ? accessLogs.build() : null;
        }

        @Override
        public final Builder accessLogs(VerifiedAccessLogOptions accessLogs) {
            this.accessLogs = accessLogs;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessInstanceLoggingConfigurationRequest build() {
            return new ModifyVerifiedAccessInstanceLoggingConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessInstanceLoggingConfigurationRequest> {
        public Builder verifiedAccessInstanceId(String var1);

        public Builder accessLogs(VerifiedAccessLogOptions var1);

        default public Builder accessLogs(Consumer<VerifiedAccessLogOptions.Builder> accessLogs) {
            return this.accessLogs((VerifiedAccessLogOptions)((VerifiedAccessLogOptions.Builder)VerifiedAccessLogOptions.builder().applyMutation(accessLogs)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

