/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BundleTaskState {
    PENDING("pending"),
    WAITING_FOR_SHUTDOWN("waiting-for-shutdown"),
    BUNDLING("bundling"),
    STORING("storing"),
    CANCELLING("cancelling"),
    COMPLETE("complete"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BundleTaskState> VALUE_MAP;
    private final String value;

    private BundleTaskState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BundleTaskState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BundleTaskState> knownValues() {
        EnumSet<BundleTaskState> knownValues = EnumSet.allOf(BundleTaskState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BundleTaskState.class, BundleTaskState::toString);
    }
}

