/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse;

public class GetNetworkInsightsAccessScopeAnalysisFindingsPublisher
implements SdkPublisher<GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
    private final Ec2AsyncClient client;
    private final GetNetworkInsightsAccessScopeAnalysisFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetNetworkInsightsAccessScopeAnalysisFindingsPublisher(Ec2AsyncClient client, GetNetworkInsightsAccessScopeAnalysisFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetNetworkInsightsAccessScopeAnalysisFindingsPublisher(Ec2AsyncClient client, GetNetworkInsightsAccessScopeAnalysisFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetNetworkInsightsAccessScopeAnalysisFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessScopeAnalysisFinding> analysisFindings() {
        Function<GetNetworkInsightsAccessScopeAnalysisFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisFindings() != null) {
                return response.analysisFindings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher
    implements AsyncPageFetcher<GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
        private GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkInsightsAccessScopeAnalysisFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetNetworkInsightsAccessScopeAnalysisFindingsResponse> nextPage(GetNetworkInsightsAccessScopeAnalysisFindingsResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkInsightsAccessScopeAnalysisFindingsPublisher.this.client.getNetworkInsightsAccessScopeAnalysisFindings(GetNetworkInsightsAccessScopeAnalysisFindingsPublisher.this.firstRequest);
            }
            return GetNetworkInsightsAccessScopeAnalysisFindingsPublisher.this.client.getNetworkInsightsAccessScopeAnalysisFindings((GetNetworkInsightsAccessScopeAnalysisFindingsRequest)((Object)GetNetworkInsightsAccessScopeAnalysisFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

