/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ReservedIntancesIdsCopier {
    static List<ReservedInstancesId> copy(Collection<? extends ReservedInstancesId> reservedIntancesIdsParam) {
        List<ReservedInstancesId> list;
        if (reservedIntancesIdsParam == null || reservedIntancesIdsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReservedInstancesId> modifiableList = new ArrayList<>();
            reservedIntancesIdsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReservedInstancesId> copyFromBuilder(Collection<? extends ReservedInstancesId.Builder> reservedIntancesIdsParam) {
        List<ReservedInstancesId> list;
        if (reservedIntancesIdsParam == null || reservedIntancesIdsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReservedInstancesId> modifiableList = new ArrayList<>();
            reservedIntancesIdsParam.forEach(entry -> {
                ReservedInstancesId member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReservedInstancesId.Builder> copyToBuilder(Collection<? extends ReservedInstancesId> reservedIntancesIdsParam) {
        List<ReservedInstancesId.Builder> list;
        if (reservedIntancesIdsParam == null || reservedIntancesIdsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReservedInstancesId.Builder> modifiableList = new ArrayList<>();
            reservedIntancesIdsParam.forEach(entry -> {
                ReservedInstancesId.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
