/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the IPv4 delegated prefixes assigned to a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ipv4PrefixSpecificationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<Ipv4PrefixSpecificationResponse.Builder, Ipv4PrefixSpecificationResponse> {
    private static final SdkField<String> IPV4_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv4Prefix")
            .getter(getter(Ipv4PrefixSpecificationResponse::ipv4Prefix))
            .setter(setter(Builder::ipv4Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix")
                    .unmarshallLocationName("ipv4Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipv4Prefix;

    private Ipv4PrefixSpecificationResponse(BuilderImpl builder) {
        this.ipv4Prefix = builder.ipv4Prefix;
    }

    /**
     * <p>
     * The IPv4 delegated prefixes assigned to the network interface.
     * </p>
     * 
     * @return The IPv4 delegated prefixes assigned to the network interface.
     */
    public final String ipv4Prefix() {
        return ipv4Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv4Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv4PrefixSpecificationResponse)) {
            return false;
        }
        Ipv4PrefixSpecificationResponse other = (Ipv4PrefixSpecificationResponse) obj;
        return Objects.equals(ipv4Prefix(), other.ipv4Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ipv4PrefixSpecificationResponse").add("Ipv4Prefix", ipv4Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv4Prefix":
            return Optional.ofNullable(clazz.cast(ipv4Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ipv4PrefixSpecificationResponse, T> g) {
        return obj -> g.apply((Ipv4PrefixSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ipv4PrefixSpecificationResponse> {
        /**
         * <p>
         * The IPv4 delegated prefixes assigned to the network interface.
         * </p>
         * 
         * @param ipv4Prefix
         *        The IPv4 delegated prefixes assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefix(String ipv4Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String ipv4Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv4PrefixSpecificationResponse model) {
            ipv4Prefix(model.ipv4Prefix);
        }

        public final String getIpv4Prefix() {
            return ipv4Prefix;
        }

        public final void setIpv4Prefix(String ipv4Prefix) {
            this.ipv4Prefix = ipv4Prefix;
        }

        @Override
        public final Builder ipv4Prefix(String ipv4Prefix) {
            this.ipv4Prefix = ipv4Prefix;
            return this;
        }

        @Override
        public Ipv4PrefixSpecificationResponse build() {
            return new Ipv4PrefixSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
