/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableImageBlockPublicAccessRequest extends Ec2Request implements
        ToCopyableBuilder<EnableImageBlockPublicAccessRequest.Builder, EnableImageBlockPublicAccessRequest> {
    private static final SdkField<String> IMAGE_BLOCK_PUBLIC_ACCESS_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageBlockPublicAccessState")
            .getter(getter(EnableImageBlockPublicAccessRequest::imageBlockPublicAccessStateAsString))
            .setter(setter(Builder::imageBlockPublicAccessState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBlockPublicAccessState")
                    .unmarshallLocationName("ImageBlockPublicAccessState").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableImageBlockPublicAccessRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IMAGE_BLOCK_PUBLIC_ACCESS_STATE_FIELD, DRY_RUN_FIELD));

    private final String imageBlockPublicAccessState;

    private final Boolean dryRun;

    private EnableImageBlockPublicAccessRequest(BuilderImpl builder) {
        super(builder);
        this.imageBlockPublicAccessState = builder.imageBlockPublicAccessState;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in the
     * specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBlockPublicAccessState} will return
     * {@link ImageBlockPublicAccessEnabledState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #imageBlockPublicAccessStateAsString}.
     * </p>
     * 
     * @return Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in the
     *         specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
     * @see ImageBlockPublicAccessEnabledState
     */
    public final ImageBlockPublicAccessEnabledState imageBlockPublicAccessState() {
        return ImageBlockPublicAccessEnabledState.fromValue(imageBlockPublicAccessState);
    }

    /**
     * <p>
     * Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in the
     * specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBlockPublicAccessState} will return
     * {@link ImageBlockPublicAccessEnabledState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #imageBlockPublicAccessStateAsString}.
     * </p>
     * 
     * @return Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in the
     *         specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
     * @see ImageBlockPublicAccessEnabledState
     */
    public final String imageBlockPublicAccessStateAsString() {
        return imageBlockPublicAccessState;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageBlockPublicAccessStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableImageBlockPublicAccessRequest)) {
            return false;
        }
        EnableImageBlockPublicAccessRequest other = (EnableImageBlockPublicAccessRequest) obj;
        return Objects.equals(imageBlockPublicAccessStateAsString(), other.imageBlockPublicAccessStateAsString())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableImageBlockPublicAccessRequest")
                .add("ImageBlockPublicAccessState", imageBlockPublicAccessStateAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBlockPublicAccessState":
            return Optional.ofNullable(clazz.cast(imageBlockPublicAccessStateAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableImageBlockPublicAccessRequest, T> g) {
        return obj -> g.apply((EnableImageBlockPublicAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableImageBlockPublicAccessRequest> {
        /**
         * <p>
         * Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in the
         * specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
         * </p>
         * 
         * @param imageBlockPublicAccessState
         *        Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in
         *        the specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
         * @see ImageBlockPublicAccessEnabledState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageBlockPublicAccessEnabledState
         */
        Builder imageBlockPublicAccessState(String imageBlockPublicAccessState);

        /**
         * <p>
         * Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in the
         * specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
         * </p>
         * 
         * @param imageBlockPublicAccessState
         *        Specify <code>block-new-sharing</code> to enable block public access for AMIs at the account level in
         *        the specified Region. This will block any attempt to publicly share your AMIs in the specified Region.
         * @see ImageBlockPublicAccessEnabledState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageBlockPublicAccessEnabledState
         */
        Builder imageBlockPublicAccessState(ImageBlockPublicAccessEnabledState imageBlockPublicAccessState);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String imageBlockPublicAccessState;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableImageBlockPublicAccessRequest model) {
            super(model);
            imageBlockPublicAccessState(model.imageBlockPublicAccessState);
            dryRun(model.dryRun);
        }

        public final String getImageBlockPublicAccessState() {
            return imageBlockPublicAccessState;
        }

        public final void setImageBlockPublicAccessState(String imageBlockPublicAccessState) {
            this.imageBlockPublicAccessState = imageBlockPublicAccessState;
        }

        @Override
        public final Builder imageBlockPublicAccessState(String imageBlockPublicAccessState) {
            this.imageBlockPublicAccessState = imageBlockPublicAccessState;
            return this;
        }

        @Override
        public final Builder imageBlockPublicAccessState(ImageBlockPublicAccessEnabledState imageBlockPublicAccessState) {
            this.imageBlockPublicAccessState(imageBlockPublicAccessState == null ? null : imageBlockPublicAccessState.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableImageBlockPublicAccessRequest build() {
            return new EnableImageBlockPublicAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
