/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform.internal;

import java.net.URI;
import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class GeneratePreSignUrlInterceptor
implements ExecutionInterceptor {
    private static final URI CUSTOM_ENDPOINT_LOCALHOST = URI.create("http://localhost");
    private static final AwsEc2ProtocolFactory PROTOCOL_FACTORY = ((AwsEc2ProtocolFactory.Builder)AwsEc2ProtocolFactory.builder().clientConfiguration(SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.ENDPOINT, (Object)CUSTOM_ENDPOINT_LOCALHOST).build())).build();
    private static final CopySnapshotRequestMarshaller MARSHALLER = new CopySnapshotRequestMarshaller((AwsQueryProtocolFactory)PROTOCOL_FACTORY);
    private final Clock testClock;

    public GeneratePreSignUrlInterceptor() {
        this.testClock = null;
    }

    @SdkTestInternalApi
    GeneratePreSignUrlInterceptor(Clock testClock) {
        this.testClock = testClock;
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof CopySnapshotRequest) {
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)originalRequest;
            if (originalCopySnapshotRequest.presignedUrl() != null) {
                return request;
            }
            String serviceName = "ec2";
            String sourceRegion = originalCopySnapshotRequest.sourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.sourceSnapshotId();
            String destinationRegion = originalCopySnapshotRequest.destinationRegion();
            if (destinationRegion == null) {
                destinationRegion = ((Region)AwsHostNameUtils.parseSigningRegion((String)request.host(), (String)serviceName).orElseThrow(() -> new IllegalArgumentException("Could not determine region for " + request.host()))).id();
            }
            URI endPointSource = this.createEndpoint(sourceRegion, serviceName);
            SdkHttpFullRequest requestForPresigning = this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion).toBuilder().uri(endPointSource).method(SdkHttpMethod.GET).build();
            Aws4Signer signer = Aws4Signer.create();
            Aws4PresignerParams signingParams = this.getPresignerParams(executionAttributes, sourceRegion, serviceName);
            SdkHttpFullRequest presignedRequest = signer.presign(requestForPresigning, signingParams);
            return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).putRawQueryParameter("DestinationRegion", destinationRegion).putRawQueryParameter("PresignedUrl", presignedRequest.getUri().toString()).build();
        }
        return request;
    }

    private Aws4PresignerParams getPresignerParams(ExecutionAttributes attributes, String signingRegion, String signingName) {
        return ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingRegion(Region.of((String)signingRegion))).signingName(signingName)).awsCredentials(this.resolveCredentials(attributes))).signingClockOverride(this.testClock)).build();
    }

    private AwsCredentials resolveCredentials(ExecutionAttributes attributes) {
        return attributes.getOptionalAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME).map(selectedAuthScheme -> selectedAuthScheme.identity()).map(identityFuture -> (Identity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).filter(identity -> identity instanceof AwsCredentialsIdentity).map(identity -> {
            AwsCredentialsIdentity awsCredentialsIdentity = (AwsCredentialsIdentity)identity;
            return CredentialUtils.toCredentials((AwsCredentialsIdentity)awsCredentialsIdentity);
        }).orElse((AwsCredentials)attributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS));
    }

    private SdkHttpFullRequest generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = (CopySnapshotRequest)((Object)CopySnapshotRequest.builder().sourceSnapshotId(sourceSnapshotId).sourceRegion(sourceRegion).destinationRegion(destinationRegion).build());
        return MARSHALLER.marshall(copySnapshotRequest);
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw SdkClientException.builder().message("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.").build();
        }
        URI endpoint = Ec2Client.serviceMetadata().endpointFor(region);
        if (endpoint.getScheme() == null) {
            return URI.create("https://" + endpoint);
        }
        return endpoint;
    }
}

