/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayRouteTablePropagation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayRouteTablePropagation> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayRouteTablePropagation.getter(TransitGatewayRouteTablePropagation::transitGatewayAttachmentId)).setter(TransitGatewayRouteTablePropagation.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayRouteTablePropagation.getter(TransitGatewayRouteTablePropagation::resourceId)).setter(TransitGatewayRouteTablePropagation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayRouteTablePropagation.getter(TransitGatewayRouteTablePropagation::resourceTypeAsString)).setter(TransitGatewayRouteTablePropagation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayRouteTablePropagation.getter(TransitGatewayRouteTablePropagation::stateAsString)).setter(TransitGatewayRouteTablePropagation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableAnnouncementId").getter(TransitGatewayRouteTablePropagation.getter(TransitGatewayRouteTablePropagation::transitGatewayRouteTableAnnouncementId)).setter(TransitGatewayRouteTablePropagation.setter(Builder::transitGatewayRouteTableAnnouncementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableAnnouncementId").unmarshallLocationName("transitGatewayRouteTableAnnouncementId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, STATE_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String resourceId;
    private final String resourceType;
    private final String state;
    private final String transitGatewayRouteTableAnnouncementId;

    private TransitGatewayRouteTablePropagation(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.transitGatewayRouteTableAnnouncementId = builder.transitGatewayRouteTableAnnouncementId;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final TransitGatewayPropagationState state() {
        return TransitGatewayPropagationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String transitGatewayRouteTableAnnouncementId() {
        return this.transitGatewayRouteTableAnnouncementId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableAnnouncementId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTablePropagation)) {
            return false;
        }
        TransitGatewayRouteTablePropagation other = (TransitGatewayRouteTablePropagation)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.transitGatewayRouteTableAnnouncementId(), other.transitGatewayRouteTableAnnouncementId());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayRouteTablePropagation").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("State", (Object)this.stateAsString()).add("TransitGatewayRouteTableAnnouncementId", (Object)this.transitGatewayRouteTableAnnouncementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "TransitGatewayRouteTableAnnouncementId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableAnnouncementId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTablePropagation, T> g) {
        return obj -> g.apply((TransitGatewayRouteTablePropagation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String resourceId;
        private String resourceType;
        private String state;
        private String transitGatewayRouteTableAnnouncementId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTablePropagation model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.state(model.state);
            this.transitGatewayRouteTableAnnouncementId(model.transitGatewayRouteTableAnnouncementId);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayPropagationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getTransitGatewayRouteTableAnnouncementId() {
            return this.transitGatewayRouteTableAnnouncementId;
        }

        public final void setTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
        }

        @Override
        public final Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
            return this;
        }

        public TransitGatewayRouteTablePropagation build() {
            return new TransitGatewayRouteTablePropagation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayRouteTablePropagation> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayPropagationState var1);

        public Builder transitGatewayRouteTableAnnouncementId(String var1);
    }
}

