/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, StartInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> STARTING_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StartingInstances").getter(StartInstancesResponse.getter(StartInstancesResponse::startingInstances)).setter(StartInstancesResponse.setter(Builder::startingInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet").unmarshallLocationName("instancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_INSTANCES_FIELD));
    private final List<InstanceStateChange> startingInstances;

    private StartInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.startingInstances = builder.startingInstances;
    }

    public final boolean hasStartingInstances() {
        return this.startingInstances != null && !(this.startingInstances instanceof SdkAutoConstructList);
    }

    public final List<InstanceStateChange> startingInstances() {
        return this.startingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartingInstances() ? this.startingInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesResponse)) {
            return false;
        }
        StartInstancesResponse other = (StartInstancesResponse)((Object)obj);
        return this.hasStartingInstances() == other.hasStartingInstances() && Objects.equals(this.startingInstances(), other.startingInstances());
    }

    public final String toString() {
        return ToString.builder((String)"StartInstancesResponse").add("StartingInstances", this.hasStartingInstances() ? this.startingInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartingInstances": {
                return Optional.ofNullable(clazz.cast(this.startingInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartInstancesResponse, T> g) {
        return obj -> g.apply((StartInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceStateChange> startingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesResponse model) {
            super(model);
            this.startingInstances(model.startingInstances);
        }

        public final List<InstanceStateChange.Builder> getStartingInstances() {
            List<InstanceStateChange.Builder> result = InstanceStateChangeListCopier.copyToBuilder(this.startingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStartingInstances(Collection<InstanceStateChange.BuilderImpl> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copyFromBuilder(startingInstances);
        }

        @Override
        public final Builder startingInstances(Collection<InstanceStateChange> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copy(startingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(InstanceStateChange ... startingInstances) {
            this.startingInstances(Arrays.asList(startingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(Consumer<InstanceStateChange.Builder> ... startingInstances) {
            this.startingInstances(Stream.of(startingInstances).map(c -> (InstanceStateChange)((InstanceStateChange.Builder)InstanceStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartInstancesResponse build() {
            return new StartInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartInstancesResponse> {
        public Builder startingInstances(Collection<InstanceStateChange> var1);

        public Builder startingInstances(InstanceStateChange ... var1);

        public Builder startingInstances(Consumer<InstanceStateChange.Builder> ... var1);
    }
}

