/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceleratorManufacturer {
    AMAZON_WEB_SERVICES("amazon-web-services"),
    AMD("amd"),
    NVIDIA("nvidia"),
    XILINX("xilinx"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceleratorManufacturer> VALUE_MAP;
    private final String value;

    private AcceleratorManufacturer(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceleratorManufacturer fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceleratorManufacturer> knownValues() {
        EnumSet<AcceleratorManufacturer> knownValues = EnumSet.allOf(AcceleratorManufacturer.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceleratorManufacturer.class, AcceleratorManufacturer::toString);
    }
}

