/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessEndpointPolicyRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVerifiedAccessEndpointPolicyRequest.Builder, ModifyVerifiedAccessEndpointPolicyRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessEndpointId")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyRequest::verifiedAccessEndpointId))
            .setter(setter(Builder::verifiedAccessEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId")
                    .unmarshallLocationName("VerifiedAccessEndpointId").build()).build();

    private static final SdkField<Boolean> POLICY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PolicyEnabled")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyRequest::policyEnabled))
            .setter(setter(Builder::policyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyEnabled")
                    .unmarshallLocationName("PolicyEnabled").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument")
                    .unmarshallLocationName("PolicyDocument").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_ENDPOINT_ID_FIELD, POLICY_ENABLED_FIELD, POLICY_DOCUMENT_FIELD, CLIENT_TOKEN_FIELD));

    private final String verifiedAccessEndpointId;

    private final Boolean policyEnabled;

    private final String policyDocument;

    private final String clientToken;

    private ModifyVerifiedAccessEndpointPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointId = builder.verifiedAccessEndpointId;
        this.policyEnabled = builder.policyEnabled;
        this.policyDocument = builder.policyDocument;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Verified Access endpoint.
     * </p>
     * 
     * @return The ID of the Verified Access endpoint.
     */
    public final String verifiedAccessEndpointId() {
        return verifiedAccessEndpointId;
    }

    /**
     * <p>
     * The status of the Verified Access policy.
     * </p>
     * 
     * @return The status of the Verified Access policy.
     */
    public final Boolean policyEnabled() {
        return policyEnabled;
    }

    /**
     * <p>
     * The Verified Access policy document.
     * </p>
     * 
     * @return The Verified Access policy document.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(policyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointPolicyRequest)) {
            return false;
        }
        ModifyVerifiedAccessEndpointPolicyRequest other = (ModifyVerifiedAccessEndpointPolicyRequest) obj;
        return Objects.equals(verifiedAccessEndpointId(), other.verifiedAccessEndpointId())
                && Objects.equals(policyEnabled(), other.policyEnabled())
                && Objects.equals(policyDocument(), other.policyDocument()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessEndpointPolicyRequest")
                .add("VerifiedAccessEndpointId", verifiedAccessEndpointId()).add("PolicyEnabled", policyEnabled())
                .add("PolicyDocument", policyDocument()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessEndpointId":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpointId()));
        case "PolicyEnabled":
            return Optional.ofNullable(clazz.cast(policyEnabled()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointPolicyRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVerifiedAccessEndpointPolicyRequest> {
        /**
         * <p>
         * The ID of the Verified Access endpoint.
         * </p>
         * 
         * @param verifiedAccessEndpointId
         *        The ID of the Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointId(String verifiedAccessEndpointId);

        /**
         * <p>
         * The status of the Verified Access policy.
         * </p>
         * 
         * @param policyEnabled
         *        The status of the Verified Access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyEnabled(Boolean policyEnabled);

        /**
         * <p>
         * The Verified Access policy document.
         * </p>
         * 
         * @param policyDocument
         *        The Verified Access policy document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String verifiedAccessEndpointId;

        private Boolean policyEnabled;

        private String policyDocument;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointPolicyRequest model) {
            super(model);
            verifiedAccessEndpointId(model.verifiedAccessEndpointId);
            policyEnabled(model.policyEnabled);
            policyDocument(model.policyDocument);
            clientToken(model.clientToken);
        }

        public final String getVerifiedAccessEndpointId() {
            return verifiedAccessEndpointId;
        }

        public final void setVerifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
        }

        @Override
        public final Builder verifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
            return this;
        }

        public final Boolean getPolicyEnabled() {
            return policyEnabled;
        }

        public final void setPolicyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
        }

        @Override
        public final Builder policyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessEndpointPolicyRequest build() {
            return new ModifyVerifiedAccessEndpointPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
