/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableAwsNetworkPerformanceMetricSubscriptionRequest extends Ec2Request
        implements
        ToCopyableBuilder<DisableAwsNetworkPerformanceMetricSubscriptionRequest.Builder, DisableAwsNetworkPerformanceMetricSubscriptionRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Source")
            .getter(getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("Source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Destination")
            .getter(getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("Destination").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Metric")
            .getter(getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::metricAsString))
            .setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric")
                    .unmarshallLocationName("Metric").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Statistic")
            .getter(getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic")
                    .unmarshallLocationName("Statistic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD));

    private final String source;

    private final String destination;

    private final String metric;

    private final String statistic;

    private DisableAwsNetworkPerformanceMetricSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
    }

    /**
     * <p>
     * The source Region or Availability Zone that the metric subscription is disabled for. For example,
     * <code>us-east-1</code>.
     * </p>
     * 
     * @return The source Region or Availability Zone that the metric subscription is disabled for. For example,
     *         <code>us-east-1</code>.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The target Region or Availability Zone that the metric subscription is disabled for. For example,
     * <code>eu-north-1</code>.
     * </p>
     * 
     * @return The target Region or Availability Zone that the metric subscription is disabled for. For example,
     *         <code>eu-north-1</code>.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The metric used for the disabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the disabled subscription.
     * @see MetricType
     */
    public final MetricType metric() {
        return MetricType.fromValue(metric);
    }

    /**
     * <p>
     * The metric used for the disabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the disabled subscription.
     * @see MetricType
     */
    public final String metricAsString() {
        return metric;
    }

    /**
     * <p>
     * The statistic used for the disabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic used for the disabled subscription.
     * @see StatisticType
     */
    public final StatisticType statistic() {
        return StatisticType.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic used for the disabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic used for the disabled subscription.
     * @see StatisticType
     */
    public final String statisticAsString() {
        return statistic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAwsNetworkPerformanceMetricSubscriptionRequest)) {
            return false;
        }
        DisableAwsNetworkPerformanceMetricSubscriptionRequest other = (DisableAwsNetworkPerformanceMetricSubscriptionRequest) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(metricAsString(), other.metricAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableAwsNetworkPerformanceMetricSubscriptionRequest").add("Source", source())
                .add("Destination", destination()).add("Metric", metricAsString()).add("Statistic", statisticAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metricAsString()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableAwsNetworkPerformanceMetricSubscriptionRequest, T> g) {
        return obj -> g.apply((DisableAwsNetworkPerformanceMetricSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableAwsNetworkPerformanceMetricSubscriptionRequest> {
        /**
         * <p>
         * The source Region or Availability Zone that the metric subscription is disabled for. For example,
         * <code>us-east-1</code>.
         * </p>
         * 
         * @param source
         *        The source Region or Availability Zone that the metric subscription is disabled for. For example,
         *        <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The target Region or Availability Zone that the metric subscription is disabled for. For example,
         * <code>eu-north-1</code>.
         * </p>
         * 
         * @param destination
         *        The target Region or Availability Zone that the metric subscription is disabled for. For example,
         *        <code>eu-north-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The metric used for the disabled subscription.
         * </p>
         * 
         * @param metric
         *        The metric used for the disabled subscription.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(String metric);

        /**
         * <p>
         * The metric used for the disabled subscription.
         * </p>
         * 
         * @param metric
         *        The metric used for the disabled subscription.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(MetricType metric);

        /**
         * <p>
         * The statistic used for the disabled subscription.
         * </p>
         * 
         * @param statistic
         *        The statistic used for the disabled subscription.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic used for the disabled subscription.
         * </p>
         * 
         * @param statistic
         *        The statistic used for the disabled subscription.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(StatisticType statistic);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String source;

        private String destination;

        private String metric;

        private String statistic;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableAwsNetworkPerformanceMetricSubscriptionRequest model) {
            super(model);
            source(model.source);
            destination(model.destination);
            metric(model.metric);
            statistic(model.statistic);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableAwsNetworkPerformanceMetricSubscriptionRequest build() {
            return new DisableAwsNetworkPerformanceMetricSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
