/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointConnectionNotificationsRequest extends Ec2Request
        implements
        ToCopyableBuilder<DeleteVpcEndpointConnectionNotificationsRequest.Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
    private static final SdkField<List<String>> CONNECTION_NOTIFICATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConnectionNotificationIds")
            .getter(getter(DeleteVpcEndpointConnectionNotificationsRequest::connectionNotificationIds))
            .setter(setter(Builder::connectionNotificationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId")
                    .unmarshallLocationName("ConnectionNotificationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONNECTION_NOTIFICATION_IDS_FIELD));

    private final List<String> connectionNotificationIds;

    private DeleteVpcEndpointConnectionNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationIds = builder.connectionNotificationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionNotificationIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectionNotificationIds() {
        return connectionNotificationIds != null && !(connectionNotificationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the notifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionNotificationIds} method.
     * </p>
     * 
     * @return The IDs of the notifications.
     */
    public final List<String> connectionNotificationIds() {
        return connectionNotificationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionNotificationIds() ? connectionNotificationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointConnectionNotificationsRequest)) {
            return false;
        }
        DeleteVpcEndpointConnectionNotificationsRequest other = (DeleteVpcEndpointConnectionNotificationsRequest) obj;
        return hasConnectionNotificationIds() == other.hasConnectionNotificationIds()
                && Objects.equals(connectionNotificationIds(), other.connectionNotificationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcEndpointConnectionNotificationsRequest")
                .add("ConnectionNotificationIds", hasConnectionNotificationIds() ? connectionNotificationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionNotificationIds":
            return Optional.ofNullable(clazz.cast(connectionNotificationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointConnectionNotificationsRequest, T> g) {
        return obj -> g.apply((DeleteVpcEndpointConnectionNotificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
        /**
         * <p>
         * The IDs of the notifications.
         * </p>
         * 
         * @param connectionNotificationIds
         *        The IDs of the notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationIds(Collection<String> connectionNotificationIds);

        /**
         * <p>
         * The IDs of the notifications.
         * </p>
         * 
         * @param connectionNotificationIds
         *        The IDs of the notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationIds(String... connectionNotificationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> connectionNotificationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointConnectionNotificationsRequest model) {
            super(model);
            connectionNotificationIds(model.connectionNotificationIds);
        }

        public final Collection<String> getConnectionNotificationIds() {
            if (connectionNotificationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return connectionNotificationIds;
        }

        public final void setConnectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ConnectionNotificationIdsListCopier.copy(connectionNotificationIds);
        }

        @Override
        public final Builder connectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ConnectionNotificationIdsListCopier.copy(connectionNotificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationIds(String... connectionNotificationIds) {
            connectionNotificationIds(Arrays.asList(connectionNotificationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointConnectionNotificationsRequest build() {
            return new DeleteVpcEndpointConnectionNotificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
