/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint;

public class DescribeInstanceConnectEndpointsIterable
implements SdkIterable<DescribeInstanceConnectEndpointsResponse> {
    private final Ec2Client client;
    private final DescribeInstanceConnectEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceConnectEndpointsIterable(Ec2Client client, DescribeInstanceConnectEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceConnectEndpointsResponseFetcher();
    }

    public Iterator<DescribeInstanceConnectEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Ec2InstanceConnectEndpoint> instanceConnectEndpoints() {
        Function<DescribeInstanceConnectEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceConnectEndpoints() != null) {
                return response.instanceConnectEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceConnectEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeInstanceConnectEndpointsResponse> {
        private DescribeInstanceConnectEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceConnectEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceConnectEndpointsResponse nextPage(DescribeInstanceConnectEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceConnectEndpointsIterable.this.client.describeInstanceConnectEndpoints(DescribeInstanceConnectEndpointsIterable.this.firstRequest);
            }
            return DescribeInstanceConnectEndpointsIterable.this.client.describeInstanceConnectEndpoints((DescribeInstanceConnectEndpointsRequest)((Object)DescribeInstanceConnectEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

