/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation;

public class DescribeIamInstanceProfileAssociationsIterable
implements SdkIterable<DescribeIamInstanceProfileAssociationsResponse> {
    private final Ec2Client client;
    private final DescribeIamInstanceProfileAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIamInstanceProfileAssociationsIterable(Ec2Client client, DescribeIamInstanceProfileAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeIamInstanceProfileAssociationsResponseFetcher();
    }

    public Iterator<DescribeIamInstanceProfileAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        Function<DescribeIamInstanceProfileAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.iamInstanceProfileAssociations() != null) {
                return response.iamInstanceProfileAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIamInstanceProfileAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeIamInstanceProfileAssociationsResponse> {
        private DescribeIamInstanceProfileAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIamInstanceProfileAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIamInstanceProfileAssociationsResponse nextPage(DescribeIamInstanceProfileAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIamInstanceProfileAssociationsIterable.this.client.describeIamInstanceProfileAssociations(DescribeIamInstanceProfileAssociationsIterable.this.firstRequest);
            }
            return DescribeIamInstanceProfileAssociationsIterable.this.client.describeIamInstanceProfileAssociations((DescribeIamInstanceProfileAssociationsRequest)((Object)DescribeIamInstanceProfileAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

