/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigListRequestCopier;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest;
import software.amazon.awssdk.services.ec2.model.SpotOptionsRequest;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateFleetRequest.getter(CreateFleetRequest::clientToken)).setter(CreateFleetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<SpotOptionsRequest> SPOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotOptions").getter(CreateFleetRequest.getter(CreateFleetRequest::spotOptions)).setter(CreateFleetRequest.setter(Builder::spotOptions)).constructor(SpotOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions").unmarshallLocationName("SpotOptions").build()}).build();
    private static final SdkField<OnDemandOptionsRequest> ON_DEMAND_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandOptions").getter(CreateFleetRequest.getter(CreateFleetRequest::onDemandOptions)).setter(CreateFleetRequest.setter(Builder::onDemandOptions)).constructor(OnDemandOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandOptions").unmarshallLocationName("OnDemandOptions").build()}).build();
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExcessCapacityTerminationPolicy").getter(CreateFleetRequest.getter(CreateFleetRequest::excessCapacityTerminationPolicyAsString)).setter(CreateFleetRequest.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("ExcessCapacityTerminationPolicy").build()}).build();
    private static final SdkField<List<FleetLaunchTemplateConfigRequest>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchTemplateConfigs").getter(CreateFleetRequest.getter(CreateFleetRequest::launchTemplateConfigs)).setter(CreateFleetRequest.setter(Builder::launchTemplateConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs").unmarshallLocationName("LaunchTemplateConfigs").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetLaunchTemplateConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<TargetCapacitySpecificationRequest> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetCapacitySpecification").getter(CreateFleetRequest.getter(CreateFleetRequest::targetCapacitySpecification)).setter(CreateFleetRequest.setter(Builder::targetCapacitySpecification)).constructor(TargetCapacitySpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification").unmarshallLocationName("TargetCapacitySpecification").build()}).build();
    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminateInstancesWithExpiration").getter(CreateFleetRequest.getter(CreateFleetRequest::terminateInstancesWithExpiration)).setter(CreateFleetRequest.setter(Builder::terminateInstancesWithExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration").unmarshallLocationName("TerminateInstancesWithExpiration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateFleetRequest.getter(CreateFleetRequest::typeAsString)).setter(CreateFleetRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidFrom").getter(CreateFleetRequest.getter(CreateFleetRequest::validFrom)).setter(CreateFleetRequest.setter(Builder::validFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").unmarshallLocationName("ValidFrom").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntil").getter(CreateFleetRequest.getter(CreateFleetRequest::validUntil)).setter(CreateFleetRequest.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").unmarshallLocationName("ValidUntil").build()}).build();
    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReplaceUnhealthyInstances").getter(CreateFleetRequest.getter(CreateFleetRequest::replaceUnhealthyInstances)).setter(CreateFleetRequest.setter(Builder::replaceUnhealthyInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances").unmarshallLocationName("ReplaceUnhealthyInstances").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateFleetRequest.getter(CreateFleetRequest::tagSpecifications)).setter(CreateFleetRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(CreateFleetRequest.getter(CreateFleetRequest::context)).setter(CreateFleetRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").unmarshallLocationName("Context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, SPOT_OPTIONS_FIELD, ON_DEMAND_OPTIONS_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD, TARGET_CAPACITY_SPECIFICATION_FIELD, TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD, REPLACE_UNHEALTHY_INSTANCES_FIELD, TAG_SPECIFICATIONS_FIELD, CONTEXT_FIELD));
    private final String clientToken;
    private final SpotOptionsRequest spotOptions;
    private final OnDemandOptionsRequest onDemandOptions;
    private final String excessCapacityTerminationPolicy;
    private final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs;
    private final TargetCapacitySpecificationRequest targetCapacitySpecification;
    private final Boolean terminateInstancesWithExpiration;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final Boolean replaceUnhealthyInstances;
    private final List<TagSpecification> tagSpecifications;
    private final String context;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.spotOptions = builder.spotOptions;
        this.onDemandOptions = builder.onDemandOptions;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.tagSpecifications = builder.tagSpecifications;
        this.context = builder.context;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final SpotOptionsRequest spotOptions() {
        return this.spotOptions;
    }

    public final OnDemandOptionsRequest onDemandOptions() {
        return this.onDemandOptions;
    }

    public final FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public final String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public final boolean hasLaunchTemplateConfigs() {
        return this.launchTemplateConfigs != null && !(this.launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    public final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs() {
        return this.launchTemplateConfigs;
    }

    public final TargetCapacitySpecificationRequest targetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public final Boolean terminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public final FleetType type() {
        return FleetType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant validFrom() {
        return this.validFrom;
    }

    public final Instant validUntil() {
        return this.validUntil;
    }

    public final Boolean replaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String context() {
        return this.context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.spotOptions(), other.spotOptions()) && Objects.equals(this.onDemandOptions(), other.onDemandOptions()) && Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && this.hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs() && Objects.equals(this.launchTemplateConfigs(), other.launchTemplateConfigs()) && Objects.equals(this.targetCapacitySpecification(), other.targetCapacitySpecification()) && Objects.equals(this.terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.replaceUnhealthyInstances(), other.replaceUnhealthyInstances()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.context(), other.context());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFleetRequest").add("ClientToken", (Object)this.clientToken()).add("SpotOptions", (Object)this.spotOptions()).add("OnDemandOptions", (Object)this.onDemandOptions()).add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("LaunchTemplateConfigs", this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null).add("TargetCapacitySpecification", (Object)this.targetCapacitySpecification()).add("TerminateInstancesWithExpiration", (Object)this.terminateInstancesWithExpiration()).add("Type", (Object)this.typeAsString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("ReplaceUnhealthyInstances", (Object)this.replaceUnhealthyInstances()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("Context", (Object)this.context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SpotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
            case "OnDemandOptions": {
                return Optional.ofNullable(clazz.cast(this.onDemandOptions()));
            }
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "LaunchTemplateConfigs": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigs()));
            }
            case "TargetCapacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.targetCapacitySpecification()));
            }
            case "TerminateInstancesWithExpiration": {
                return Optional.ofNullable(clazz.cast(this.terminateInstancesWithExpiration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "ReplaceUnhealthyInstances": {
                return Optional.ofNullable(clazz.cast(this.replaceUnhealthyInstances()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private SpotOptionsRequest spotOptions;
        private OnDemandOptionsRequest onDemandOptions;
        private String excessCapacityTerminationPolicy;
        private List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();
        private TargetCapacitySpecificationRequest targetCapacitySpecification;
        private Boolean terminateInstancesWithExpiration;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private Boolean replaceUnhealthyInstances;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.spotOptions(model.spotOptions);
            this.onDemandOptions(model.onDemandOptions);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.launchTemplateConfigs(model.launchTemplateConfigs);
            this.targetCapacitySpecification(model.targetCapacitySpecification);
            this.terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            this.tagSpecifications(model.tagSpecifications);
            this.context(model.context);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final SpotOptionsRequest.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotOptionsRequest.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptionsRequest spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final OnDemandOptionsRequest.Builder getOnDemandOptions() {
            return this.onDemandOptions != null ? this.onDemandOptions.toBuilder() : null;
        }

        public final void setOnDemandOptions(OnDemandOptionsRequest.BuilderImpl onDemandOptions) {
            this.onDemandOptions = onDemandOptions != null ? onDemandOptions.build() : null;
        }

        @Override
        public final Builder onDemandOptions(OnDemandOptionsRequest onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final List<FleetLaunchTemplateConfigRequest.Builder> getLaunchTemplateConfigs() {
            List<FleetLaunchTemplateConfigRequest.Builder> result = FleetLaunchTemplateConfigListRequestCopier.copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copyFromBuilder(launchTemplateConfigs);
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder> ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Stream.of(launchTemplateConfigs).map(c -> (FleetLaunchTemplateConfigRequest)((FleetLaunchTemplateConfigRequest.Builder)FleetLaunchTemplateConfigRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TargetCapacitySpecificationRequest.Builder getTargetCapacitySpecification() {
            return this.targetCapacitySpecification != null ? this.targetCapacitySpecification.toBuilder() : null;
        }

        public final void setTargetCapacitySpecification(TargetCapacitySpecificationRequest.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder clientToken(String var1);

        public Builder spotOptions(SpotOptionsRequest var1);

        default public Builder spotOptions(Consumer<SpotOptionsRequest.Builder> spotOptions) {
            return this.spotOptions((SpotOptionsRequest)((SpotOptionsRequest.Builder)SpotOptionsRequest.builder().applyMutation(spotOptions)).build());
        }

        public Builder onDemandOptions(OnDemandOptionsRequest var1);

        default public Builder onDemandOptions(Consumer<OnDemandOptionsRequest.Builder> onDemandOptions) {
            return this.onDemandOptions((OnDemandOptionsRequest)((OnDemandOptionsRequest.Builder)OnDemandOptionsRequest.builder().applyMutation(onDemandOptions)).build());
        }

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy var1);

        public Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> var1);

        public Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest ... var1);

        public Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder> ... var1);

        public Builder targetCapacitySpecification(TargetCapacitySpecificationRequest var1);

        default public Builder targetCapacitySpecification(Consumer<TargetCapacitySpecificationRequest.Builder> targetCapacitySpecification) {
            return this.targetCapacitySpecification((TargetCapacitySpecificationRequest)((TargetCapacitySpecificationRequest.Builder)TargetCapacitySpecificationRequest.builder().applyMutation(targetCapacitySpecification)).build());
        }

        public Builder terminateInstancesWithExpiration(Boolean var1);

        public Builder type(String var1);

        public Builder type(FleetType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder replaceUnhealthyInstances(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder context(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

