/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotTask;

public class DescribeImportSnapshotTasksIterable
implements SdkIterable<DescribeImportSnapshotTasksResponse> {
    private final Ec2Client client;
    private final DescribeImportSnapshotTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImportSnapshotTasksIterable(Ec2Client client, DescribeImportSnapshotTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImportSnapshotTasksResponseFetcher();
    }

    public Iterator<DescribeImportSnapshotTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportSnapshotTask> importSnapshotTasks() {
        Function<DescribeImportSnapshotTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.importSnapshotTasks() != null) {
                return response.importSnapshotTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImportSnapshotTasksResponseFetcher
    implements SyncPageFetcher<DescribeImportSnapshotTasksResponse> {
        private DescribeImportSnapshotTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportSnapshotTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImportSnapshotTasksResponse nextPage(DescribeImportSnapshotTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportSnapshotTasksIterable.this.client.describeImportSnapshotTasks(DescribeImportSnapshotTasksIterable.this.firstRequest);
            }
            return DescribeImportSnapshotTasksIterable.this.client.describeImportSnapshotTasks((DescribeImportSnapshotTasksRequest)((Object)DescribeImportSnapshotTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

