/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse;
import software.amazon.awssdk.services.ec2.model.PrefixListEntry;

public class GetManagedPrefixListEntriesPublisher
implements SdkPublisher<GetManagedPrefixListEntriesResponse> {
    private final Ec2AsyncClient client;
    private final GetManagedPrefixListEntriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetManagedPrefixListEntriesPublisher(Ec2AsyncClient client, GetManagedPrefixListEntriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetManagedPrefixListEntriesPublisher(Ec2AsyncClient client, GetManagedPrefixListEntriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetManagedPrefixListEntriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetManagedPrefixListEntriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrefixListEntry> entries() {
        Function<GetManagedPrefixListEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetManagedPrefixListEntriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetManagedPrefixListEntriesResponseFetcher
    implements AsyncPageFetcher<GetManagedPrefixListEntriesResponse> {
        private GetManagedPrefixListEntriesResponseFetcher() {
        }

        public boolean hasNextPage(GetManagedPrefixListEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetManagedPrefixListEntriesResponse> nextPage(GetManagedPrefixListEntriesResponse previousPage) {
            if (previousPage == null) {
                return GetManagedPrefixListEntriesPublisher.this.client.getManagedPrefixListEntries(GetManagedPrefixListEntriesPublisher.this.firstRequest);
            }
            return GetManagedPrefixListEntriesPublisher.this.client.getManagedPrefixListEntries((GetManagedPrefixListEntriesRequest)((Object)GetManagedPrefixListEntriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

