/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.Ipv6PrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkInterfaceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateNetworkInterfaceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::description)).setter(CreateNetworkInterfaceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::groups)).setter(CreateNetworkInterfaceRequest.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::ipv6AddressCount)).setter(CreateNetworkInterfaceRequest.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("ipv6AddressCount").build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::ipv6Addresses)).setter(CreateNetworkInterfaceRequest.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").unmarshallLocationName("ipv6Addresses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::privateIpAddress)).setter(CreateNetworkInterfaceRequest.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::privateIpAddresses)).setter(CreateNetworkInterfaceRequest.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses").unmarshallLocationName("privateIpAddresses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateIpAddressSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondaryPrivateIpAddressCount").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::secondaryPrivateIpAddressCount)).setter(CreateNetworkInterfaceRequest.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("secondaryPrivateIpAddressCount").build()}).build();
    private static final SdkField<List<Ipv4PrefixSpecificationRequest>> IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4Prefixes").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::ipv4Prefixes)).setter(CreateNetworkInterfaceRequest.setter(Builder::ipv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix").unmarshallLocationName("Ipv4Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv4PrefixSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4PrefixCount").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::ipv4PrefixCount)).setter(CreateNetworkInterfaceRequest.setter(Builder::ipv4PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount").unmarshallLocationName("Ipv4PrefixCount").build()}).build();
    private static final SdkField<List<Ipv6PrefixSpecificationRequest>> IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Prefixes").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::ipv6Prefixes)).setter(CreateNetworkInterfaceRequest.setter(Builder::ipv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix").unmarshallLocationName("Ipv6Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6PrefixSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6PrefixCount").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::ipv6PrefixCount)).setter(CreateNetworkInterfaceRequest.setter(Builder::ipv6PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount").unmarshallLocationName("Ipv6PrefixCount").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::interfaceTypeAsString)).setter(CreateNetworkInterfaceRequest.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("InterfaceType").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::subnetId)).setter(CreateNetworkInterfaceRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::tagSpecifications)).setter(CreateNetworkInterfaceRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::clientToken)).setter(CreateNetworkInterfaceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrimaryIpv6").getter(CreateNetworkInterfaceRequest.getter(CreateNetworkInterfaceRequest::enablePrimaryIpv6)).setter(CreateNetworkInterfaceRequest.setter(Builder::enablePrimaryIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6").unmarshallLocationName("EnablePrimaryIpv6").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, GROUPS_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, IPV4_PREFIXES_FIELD, IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, IPV6_PREFIX_COUNT_FIELD, INTERFACE_TYPE_FIELD, SUBNET_ID_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, ENABLE_PRIMARY_IPV6_FIELD));
    private final String description;
    private final List<String> groups;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String privateIpAddress;
    private final List<PrivateIpAddressSpecification> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;
    private final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes;
    private final Integer ipv4PrefixCount;
    private final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes;
    private final Integer ipv6PrefixCount;
    private final String interfaceType;
    private final String subnetId;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final Boolean enablePrimaryIpv6;

    private CreateNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.interfaceType = builder.interfaceType;
        this.subnetId = builder.subnetId;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public final boolean hasIpv4Prefixes() {
        return this.ipv4Prefixes != null && !(this.ipv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public final Integer ipv4PrefixCount() {
        return this.ipv4PrefixCount;
    }

    public final boolean hasIpv6Prefixes() {
        return this.ipv6Prefixes != null && !(this.ipv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public final Integer ipv6PrefixCount() {
        return this.ipv6PrefixCount;
    }

    public final NetworkInterfaceCreationType interfaceType() {
        return NetworkInterfaceCreationType.fromValue(this.interfaceType);
    }

    public final String interfaceTypeAsString() {
        return this.interfaceType;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean enablePrimaryIpv6() {
        return this.enablePrimaryIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrimaryIpv6());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceRequest)) {
            return false;
        }
        CreateNetworkInterfaceRequest other = (CreateNetworkInterfaceRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount()) && this.hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(this.ipv4Prefixes(), other.ipv4Prefixes()) && Objects.equals(this.ipv4PrefixCount(), other.ipv4PrefixCount()) && this.hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(this.ipv6Prefixes(), other.ipv6Prefixes()) && Objects.equals(this.ipv6PrefixCount(), other.ipv6PrefixCount()) && Objects.equals(this.interfaceTypeAsString(), other.interfaceTypeAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.enablePrimaryIpv6(), other.enablePrimaryIpv6());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkInterfaceRequest").add("Description", (Object)this.description()).add("Groups", this.hasGroups() ? this.groups() : null).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).add("Ipv4Prefixes", this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null).add("Ipv4PrefixCount", (Object)this.ipv4PrefixCount()).add("Ipv6Prefixes", this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null).add("Ipv6PrefixCount", (Object)this.ipv6PrefixCount()).add("InterfaceType", (Object)this.interfaceTypeAsString()).add("SubnetId", (Object)this.subnetId()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("EnablePrimaryIpv6", (Object)this.enablePrimaryIpv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
            case "Ipv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv4Prefixes()));
            }
            case "Ipv4PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv4PrefixCount()));
            }
            case "Ipv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv6Prefixes()));
            }
            case "Ipv6PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6PrefixCount()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceTypeAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "EnablePrimaryIpv6": {
                return Optional.ofNullable(clazz.cast(this.enablePrimaryIpv6()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfaceRequest, T> g) {
        return obj -> g.apply((CreateNetworkInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String privateIpAddress;
        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;
        private List<Ipv4PrefixSpecificationRequest> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv4PrefixCount;
        private List<Ipv6PrefixSpecificationRequest> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6PrefixCount;
        private String interfaceType;
        private String subnetId;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Boolean enablePrimaryIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfaceRequest model) {
            super(model);
            this.description(model.description);
            this.groups(model.groups);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.ipv4Prefixes(model.ipv4Prefixes);
            this.ipv4PrefixCount(model.ipv4PrefixCount);
            this.ipv6Prefixes(model.ipv6Prefixes);
            this.ipv6PrefixCount(model.ipv6PrefixCount);
            this.interfaceType(model.interfaceType);
            this.subnetId(model.subnetId);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.enablePrimaryIpv6(model.enablePrimaryIpv6);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (PrivateIpAddressSpecification)((PrivateIpAddressSpecification.Builder)PrivateIpAddressSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final List<Ipv4PrefixSpecificationRequest.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationRequest.Builder> result = Ipv4PrefixListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationRequest.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest ... ipv4Prefixes) {
            this.ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder> ... ipv4Prefixes) {
            this.ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> (Ipv4PrefixSpecificationRequest)((Ipv4PrefixSpecificationRequest.Builder)Ipv4PrefixSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return this.ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<Ipv6PrefixSpecificationRequest.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationRequest.Builder> result = Ipv6PrefixListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationRequest.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest ... ipv6Prefixes) {
            this.ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder> ... ipv6Prefixes) {
            this.ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> (Ipv6PrefixSpecificationRequest)((Ipv6PrefixSpecificationRequest.Builder)Ipv6PrefixSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return this.ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceCreationType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return this.enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInterfaceRequest build() {
            return new CreateNetworkInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkInterfaceRequest> {
        public Builder description(String var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> var1);

        public Builder privateIpAddresses(PrivateIpAddressSpecification ... var1);

        public Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> var1);

        public Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest ... var1);

        public Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder> ... var1);

        public Builder ipv4PrefixCount(Integer var1);

        public Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> var1);

        public Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest ... var1);

        public Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder> ... var1);

        public Builder ipv6PrefixCount(Integer var1);

        public Builder interfaceType(String var1);

        public Builder interfaceType(NetworkInterfaceCreationType var1);

        public Builder subnetId(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder enablePrimaryIpv6(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

