/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkInterfaceStatus {
    AVAILABLE("available"),
    ASSOCIATED("associated"),
    ATTACHING("attaching"),
    IN_USE("in-use"),
    DETACHING("detaching"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceStatus> VALUE_MAP;
    private final String value;

    private NetworkInterfaceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceStatus> knownValues() {
        EnumSet<NetworkInterfaceStatus> knownValues = EnumSet.allOf(NetworkInterfaceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfaceStatus.class, NetworkInterfaceStatus::toString);
    }
}

