/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceMaintenanceOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceMaintenanceOptionsRequest.Builder, ModifyInstanceMaintenanceOptionsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceMaintenanceOptionsRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoRecovery")
            .getter(getter(ModifyInstanceMaintenanceOptionsRequest::autoRecoveryAsString))
            .setter(setter(Builder::autoRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery")
                    .unmarshallLocationName("AutoRecovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            AUTO_RECOVERY_FIELD));

    private final String instanceId;

    private final String autoRecovery;

    private ModifyInstanceMaintenanceOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.autoRecovery = builder.autoRecovery;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Disables the automatic recovery behavior of your instance or sets it to default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRecovery} will
     * return {@link InstanceAutoRecoveryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRecoveryAsString}.
     * </p>
     * 
     * @return Disables the automatic recovery behavior of your instance or sets it to default.
     * @see InstanceAutoRecoveryState
     */
    public final InstanceAutoRecoveryState autoRecovery() {
        return InstanceAutoRecoveryState.fromValue(autoRecovery);
    }

    /**
     * <p>
     * Disables the automatic recovery behavior of your instance or sets it to default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRecovery} will
     * return {@link InstanceAutoRecoveryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRecoveryAsString}.
     * </p>
     * 
     * @return Disables the automatic recovery behavior of your instance or sets it to default.
     * @see InstanceAutoRecoveryState
     */
    public final String autoRecoveryAsString() {
        return autoRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(autoRecoveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceMaintenanceOptionsRequest)) {
            return false;
        }
        ModifyInstanceMaintenanceOptionsRequest other = (ModifyInstanceMaintenanceOptionsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(autoRecoveryAsString(), other.autoRecoveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceMaintenanceOptionsRequest").add("InstanceId", instanceId())
                .add("AutoRecovery", autoRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AutoRecovery":
            return Optional.ofNullable(clazz.cast(autoRecoveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceMaintenanceOptionsRequest, T> g) {
        return obj -> g.apply((ModifyInstanceMaintenanceOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceMaintenanceOptionsRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Disables the automatic recovery behavior of your instance or sets it to default.
         * </p>
         * 
         * @param autoRecovery
         *        Disables the automatic recovery behavior of your instance or sets it to default.
         * @see InstanceAutoRecoveryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAutoRecoveryState
         */
        Builder autoRecovery(String autoRecovery);

        /**
         * <p>
         * Disables the automatic recovery behavior of your instance or sets it to default.
         * </p>
         * 
         * @param autoRecovery
         *        Disables the automatic recovery behavior of your instance or sets it to default.
         * @see InstanceAutoRecoveryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAutoRecoveryState
         */
        Builder autoRecovery(InstanceAutoRecoveryState autoRecovery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceId;

        private String autoRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceMaintenanceOptionsRequest model) {
            super(model);
            instanceId(model.instanceId);
            autoRecovery(model.autoRecovery);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAutoRecovery() {
            return autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public final Builder autoRecovery(InstanceAutoRecoveryState autoRecovery) {
            this.autoRecovery(autoRecovery == null ? null : autoRecovery.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceMaintenanceOptionsRequest build() {
            return new ModifyInstanceMaintenanceOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
