/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceAttributeRequest.Builder, ModifyInstanceAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("SourceDestCheck")
            .getter(getter(ModifyInstanceAttributeRequest::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("SourceDestCheck").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(ModifyInstanceAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("attribute").build()).build();

    private static final SdkField<List<InstanceBlockDeviceMappingSpecification>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMappingSpecification>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(ModifyInstanceAttributeRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMappingSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMappingSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AttributeBooleanValue> DISABLE_API_TERMINATION_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("DisableApiTermination")
            .getter(getter(ModifyInstanceAttributeRequest::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination")
                    .unmarshallLocationName("disableApiTermination").build()).build();

    private static final SdkField<AttributeBooleanValue> EBS_OPTIMIZED_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EbsOptimized")
            .getter(getter(ModifyInstanceAttributeRequest::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<AttributeBooleanValue> ENA_SUPPORT_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSupport")
            .getter(getter(ModifyInstanceAttributeRequest::enaSupport))
            .setter(setter(Builder::enaSupport))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(ModifyInstanceAttributeRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("GroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("groupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GroupId").unmarshallLocationName("groupId").build()).build())
                            .build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceAttributeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<AttributeValue> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceInitiatedShutdownBehavior")
            .getter(getter(ModifyInstanceAttributeRequest::instanceInitiatedShutdownBehavior))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .unmarshallLocationName("instanceInitiatedShutdownBehavior").build()).build();

    private static final SdkField<AttributeValue> INSTANCE_TYPE_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceType")
            .getter(getter(ModifyInstanceAttributeRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<AttributeValue> KERNEL_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Kernel")
            .getter(getter(ModifyInstanceAttributeRequest::kernel))
            .setter(setter(Builder::kernel))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel")
                    .unmarshallLocationName("kernel").build()).build();

    private static final SdkField<AttributeValue> RAMDISK_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Ramdisk")
            .getter(getter(ModifyInstanceAttributeRequest::ramdisk))
            .setter(setter(Builder::ramdisk))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk")
                    .unmarshallLocationName("ramdisk").build()).build();

    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("SriovNetSupport")
            .getter(getter(ModifyInstanceAttributeRequest::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<BlobAttributeValue> USER_DATA_FIELD = SdkField
            .<BlobAttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("UserData")
            .getter(getter(ModifyInstanceAttributeRequest::userData))
            .setter(setter(Builder::userData))
            .constructor(BlobAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("userData").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(ModifyInstanceAttributeRequest::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("value").build()).build();

    private static final SdkField<AttributeBooleanValue> DISABLE_API_STOP_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("DisableApiStop")
            .getter(getter(ModifyInstanceAttributeRequest::disableApiStop))
            .setter(setter(Builder::disableApiStop))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop")
                    .unmarshallLocationName("DisableApiStop").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DEST_CHECK_FIELD,
            ATTRIBUTE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DISABLE_API_TERMINATION_FIELD, EBS_OPTIMIZED_FIELD, ENA_SUPPORT_FIELD,
            GROUPS_FIELD, INSTANCE_ID_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, INSTANCE_TYPE_FIELD, KERNEL_FIELD,
            RAMDISK_FIELD, SRIOV_NET_SUPPORT_FIELD, USER_DATA_FIELD, VALUE_FIELD, DISABLE_API_STOP_FIELD));

    private final AttributeBooleanValue sourceDestCheck;

    private final String attribute;

    private final List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;

    private final AttributeBooleanValue disableApiTermination;

    private final AttributeBooleanValue ebsOptimized;

    private final AttributeBooleanValue enaSupport;

    private final List<String> groups;

    private final String instanceId;

    private final AttributeValue instanceInitiatedShutdownBehavior;

    private final AttributeValue instanceType;

    private final AttributeValue kernel;

    private final AttributeValue ramdisk;

    private final AttributeValue sriovNetSupport;

    private final BlobAttributeValue userData;

    private final String value;

    private final AttributeBooleanValue disableApiStop;

    private ModifyInstanceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDestCheck = builder.sourceDestCheck;
        this.attribute = builder.attribute;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernel = builder.kernel;
        this.ramdisk = builder.ramdisk;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
        this.value = builder.value;
        this.disableApiStop = builder.disableApiStop;
    }

    /**
     * <p>
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the
     * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
     * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     * source/destination checks if the instance runs services such as network address translation, routing, or
     * firewalls.
     * </p>
     * 
     * @return Enable or disable source/destination checks, which ensure that the instance is either the source or the
     *         destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks
     *         are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     *         source/destination checks if the instance runs services such as network address translation, routing, or
     *         firewalls.
     */
    public final AttributeBooleanValue sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The name of the attribute to modify.
     * </p>
     * <important>
     * <p>
     * You can modify the following attributes only: <code>disableApiTermination</code> | <code>instanceType</code> |
     * <code>kernel</code> | <code>ramdisk</code> | <code>instanceInitiatedShutdownBehavior</code> |
     * <code>blockDeviceMapping</code> | <code>userData</code> | <code>sourceDestCheck</code> | <code>groupSet</code> |
     * <code>ebsOptimized</code> | <code>sriovNetSupport</code> | <code>enaSupport</code> | <code>nvmeSupport</code> |
     * <code>disableApiStop</code> | <code>enclaveOptions</code>
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link InstanceAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The name of the attribute to modify.</p> <important>
     *         <p>
     *         You can modify the following attributes only: <code>disableApiTermination</code> |
     *         <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
     *         <code>instanceInitiatedShutdownBehavior</code> | <code>blockDeviceMapping</code> | <code>userData</code>
     *         | <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> |
     *         <code>sriovNetSupport</code> | <code>enaSupport</code> | <code>nvmeSupport</code> |
     *         <code>disableApiStop</code> | <code>enclaveOptions</code>
     *         </p>
     * @see InstanceAttributeName
     */
    public final InstanceAttributeName attribute() {
        return InstanceAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The name of the attribute to modify.
     * </p>
     * <important>
     * <p>
     * You can modify the following attributes only: <code>disableApiTermination</code> | <code>instanceType</code> |
     * <code>kernel</code> | <code>ramdisk</code> | <code>instanceInitiatedShutdownBehavior</code> |
     * <code>blockDeviceMapping</code> | <code>userData</code> | <code>sourceDestCheck</code> | <code>groupSet</code> |
     * <code>ebsOptimized</code> | <code>sriovNetSupport</code> | <code>enaSupport</code> | <code>nvmeSupport</code> |
     * <code>disableApiStop</code> | <code>enclaveOptions</code>
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link InstanceAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The name of the attribute to modify.</p> <important>
     *         <p>
     *         You can modify the following attributes only: <code>disableApiTermination</code> |
     *         <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
     *         <code>instanceInitiatedShutdownBehavior</code> | <code>blockDeviceMapping</code> | <code>userData</code>
     *         | <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> |
     *         <code>sriovNetSupport</code> | <code>enaSupport</code> | <code>nvmeSupport</code> |
     *         <code>disableApiStop</code> | <code>enclaveOptions</code>
     *         </p>
     * @see InstanceAttributeName
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume must
     * be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
     * <code>true</code> and the volume is deleted when the instance is terminated.
     * </p>
     * <p>
     * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
     * >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The
     *         volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the
     *         default is <code>true</code> and the volume is deleted when the instance is terminated.</p>
     *         <p>
     *         To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
     *         instance. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
     *         >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or API;
     * otherwise, you can. You cannot use this parameter for Spot Instances.
     * </p>
     * 
     * @return If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or
     *         API; otherwise, you can. You cannot use this parameter for Spot Instances.
     */
    public final AttributeBooleanValue disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
     * isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * 
     * @return Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
     *         This optimization isn't available with all instance types. Additional usage charges apply when using an
     *         EBS Optimized instance.
     */
    public final AttributeBooleanValue ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Set to <code>true</code> to enable enhanced networking with ENA for the instance.
     * </p>
     * <p>
     * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     * unreachable.
     * </p>
     * 
     * @return Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p>
     *         <p>
     *         This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     *         unreachable.
     */
    public final AttributeBooleanValue enaSupport() {
        return enaSupport;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replaces the security groups of the instance with the specified security groups. You must specify the ID of at
     * least one security group, even if it's just the default security group for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Replaces the security groups of the instance with the specified security groups. You must specify the ID
     *         of at least one security group, even if it's just the default security group for the VPC.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * 
     * @return Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     */
    public final AttributeValue instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * Changes the instance type to the specified value. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>. If the instance type is not valid, the error returned is
     * <code>InvalidInstanceAttributeValue</code>.
     * </p>
     * 
     * @return Changes the instance type to the specified value. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>. If the instance type is not valid, the error returned is
     *         <code>InvalidInstanceAttributeValue</code>.
     */
    public final AttributeValue instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and
     * RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     * </p>
     * 
     * @return Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of
     *         kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     */
    public final AttributeValue kernel() {
        return kernel;
    }

    /**
     * <p>
     * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and
     * RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     * </p>
     * 
     * @return Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of
     *         kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     */
    public final AttributeValue ramdisk() {
        return ramdisk;
    }

    /**
     * <p>
     * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the
     * instance.
     * </p>
     * <p>
     * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
     * </p>
     * <p>
     * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     * unreachable.
     * </p>
     * 
     * @return Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface
     *         for the instance.</p>
     *         <p>
     *         There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this
     *         time.
     *         </p>
     *         <p>
     *         This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     *         unreachable.
     */
    public final AttributeValue sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or command
     * line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
     * provide base64-encoded text.
     * </p>
     * 
     * @return Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or
     *         command line tool, base64-encoding is performed for you, and you can load the text from a file.
     *         Otherwise, you must provide base64-encoded text.
     */
    public final BlobAttributeValue userData() {
        return userData;
    }

    /**
     * <p>
     * A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>, <code>userData</code>, <code>disableApiTermination</code>, or <code>instanceInitiatedShutdownBehavior</code> attribute.
     * </p>
     * 
     * @return A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>,
     *         <code>userData</code>, <code>disableApiTermination</code>, or
     *         <code>instanceInitiatedShutdownBehavior</code> attribute.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Indicates whether an instance is enabled for stop protection. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop
     * Protection</a>.
     * </p>
     * <p/>
     * 
     * @return Indicates whether an instance is enabled for stop protection. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop
     *         Protection</a>.
     *         </p>
     */
    public final AttributeBooleanValue disableApiStop() {
        return disableApiStop;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernel());
        hashCode = 31 * hashCode + Objects.hashCode(ramdisk());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiStop());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceAttributeRequest)) {
            return false;
        }
        ModifyInstanceAttributeRequest other = (ModifyInstanceAttributeRequest) obj;
        return Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(attributeAsString(), other.attributeAsString())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(ebsOptimized(), other.ebsOptimized()) && Objects.equals(enaSupport(), other.enaSupport())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernel(), other.kernel())
                && Objects.equals(ramdisk(), other.ramdisk()) && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(userData(), other.userData()) && Objects.equals(value(), other.value())
                && Objects.equals(disableApiStop(), other.disableApiStop());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceAttributeRequest").add("SourceDestCheck", sourceDestCheck())
                .add("Attribute", attributeAsString())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("DisableApiTermination", disableApiTermination()).add("EbsOptimized", ebsOptimized())
                .add("EnaSupport", enaSupport()).add("Groups", hasGroups() ? groups() : null).add("InstanceId", instanceId())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehavior())
                .add("InstanceType", instanceType()).add("Kernel", kernel()).add("Ramdisk", ramdisk())
                .add("SriovNetSupport", sriovNetSupport()).add("UserData", userData()).add("Value", value())
                .add("DisableApiStop", disableApiStop()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehavior()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Kernel":
            return Optional.ofNullable(clazz.cast(kernel()));
        case "Ramdisk":
            return Optional.ofNullable(clazz.cast(ramdisk()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "DisableApiStop":
            return Optional.ofNullable(clazz.cast(disableApiStop()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceAttributeRequest, T> g) {
        return obj -> g.apply((ModifyInstanceAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * 
         * @param sourceDestCheck
         *        Enable or disable source/destination checks, which ensure that the instance is either the source or
         *        the destination of any traffic that it receives. If the value is <code>true</code>, source/destination
         *        checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must
         *        disable source/destination checks if the instance runs services such as network address translation,
         *        routing, or firewalls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck);

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDestCheck(AttributeBooleanValue)}.
         * 
         * @param sourceDestCheck
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDestCheck(AttributeBooleanValue)
         */
        default Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return sourceDestCheck(AttributeBooleanValue.builder().applyMutation(sourceDestCheck).build());
        }

        /**
         * <p>
         * The name of the attribute to modify.
         * </p>
         * <important>
         * <p>
         * You can modify the following attributes only: <code>disableApiTermination</code> | <code>instanceType</code>
         * | <code>kernel</code> | <code>ramdisk</code> | <code>instanceInitiatedShutdownBehavior</code> |
         * <code>blockDeviceMapping</code> | <code>userData</code> | <code>sourceDestCheck</code> |
         * <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code> | <code>enaSupport</code> |
         * <code>nvmeSupport</code> | <code>disableApiStop</code> | <code>enclaveOptions</code>
         * </p>
         * </important>
         * 
         * @param attribute
         *        The name of the attribute to modify.</p> <important>
         *        <p>
         *        You can modify the following attributes only: <code>disableApiTermination</code> |
         *        <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
         *        <code>instanceInitiatedShutdownBehavior</code> | <code>blockDeviceMapping</code> |
         *        <code>userData</code> | <code>sourceDestCheck</code> | <code>groupSet</code> |
         *        <code>ebsOptimized</code> | <code>sriovNetSupport</code> | <code>enaSupport</code> |
         *        <code>nvmeSupport</code> | <code>disableApiStop</code> | <code>enclaveOptions</code>
         *        </p>
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The name of the attribute to modify.
         * </p>
         * <important>
         * <p>
         * You can modify the following attributes only: <code>disableApiTermination</code> | <code>instanceType</code>
         * | <code>kernel</code> | <code>ramdisk</code> | <code>instanceInitiatedShutdownBehavior</code> |
         * <code>blockDeviceMapping</code> | <code>userData</code> | <code>sourceDestCheck</code> |
         * <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code> | <code>enaSupport</code> |
         * <code>nvmeSupport</code> | <code>disableApiStop</code> | <code>enclaveOptions</code>
         * </p>
         * </important>
         * 
         * @param attribute
         *        The name of the attribute to modify.</p> <important>
         *        <p>
         *        You can modify the following attributes only: <code>disableApiTermination</code> |
         *        <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
         *        <code>instanceInitiatedShutdownBehavior</code> | <code>blockDeviceMapping</code> |
         *        <code>userData</code> | <code>sourceDestCheck</code> | <code>groupSet</code> |
         *        <code>ebsOptimized</code> | <code>sriovNetSupport</code> | <code>enaSupport</code> |
         *        <code>nvmeSupport</code> | <code>disableApiStop</code> | <code>enclaveOptions</code>
         *        </p>
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(InstanceAttributeName attribute);

        /**
         * <p>
         * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume
         * must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
         * <code>true</code> and the volume is deleted when the instance is terminated.
         * </p>
         * <p>
         * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         * instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         * >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The
         *        volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the
         *        default is <code>true</code> and the volume is deleted when the instance is terminated.</p>
         *        <p>
         *        To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         *        instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         *        >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings);

        /**
         * <p>
         * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume
         * must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
         * <code>true</code> and the volume is deleted when the instance is terminated.
         * </p>
         * <p>
         * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         * instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         * >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The
         *        volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the
         *        default is <code>true</code> and the volume is deleted when the instance is terminated.</p>
         *        <p>
         *        To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         *        instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         *        >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification... blockDeviceMappings);

        /**
         * <p>
         * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume
         * must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
         * <code>true</code> and the volume is deleted when the instance is terminated.
         * </p>
         * <p>
         * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         * instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         * >Update the block device mapping when launching an instance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<InstanceBlockDeviceMappingSpecification>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<InstanceBlockDeviceMappingSpecification>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMappingSpecification.Builder>... blockDeviceMappings);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or
         * API; otherwise, you can. You cannot use this parameter for Spot Instances.
         * </p>
         * 
         * @param disableApiTermination
         *        If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI,
         *        or API; otherwise, you can. You cannot use this parameter for Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(AttributeBooleanValue disableApiTermination);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or
         * API; otherwise, you can. You cannot use this parameter for Spot Instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #disableApiTermination(AttributeBooleanValue)}.
         * 
         * @param disableApiTermination
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disableApiTermination(AttributeBooleanValue)
         */
        default Builder disableApiTermination(Consumer<AttributeBooleanValue.Builder> disableApiTermination) {
            return disableApiTermination(AttributeBooleanValue.builder().applyMutation(disableApiTermination).build());
        }

        /**
         * <p>
         * Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This
         * optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         * Optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS Optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(AttributeBooleanValue ebsOptimized);

        /**
         * <p>
         * Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This
         * optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         * Optimized instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #ebsOptimized(AttributeBooleanValue)}.
         * 
         * @param ebsOptimized
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsOptimized(AttributeBooleanValue)
         */
        default Builder ebsOptimized(Consumer<AttributeBooleanValue.Builder> ebsOptimized) {
            return ebsOptimized(AttributeBooleanValue.builder().applyMutation(ebsOptimized).build());
        }

        /**
         * <p>
         * Set to <code>true</code> to enable enhanced networking with ENA for the instance.
         * </p>
         * <p>
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         * unreachable.
         * </p>
         * 
         * @param enaSupport
         *        Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p>
         *        <p>
         *        This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         *        unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(AttributeBooleanValue enaSupport);

        /**
         * <p>
         * Set to <code>true</code> to enable enhanced networking with ENA for the instance.
         * </p>
         * <p>
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         * unreachable.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enaSupport(AttributeBooleanValue)}.
         * 
         * @param enaSupport
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSupport(AttributeBooleanValue)
         */
        default Builder enaSupport(Consumer<AttributeBooleanValue.Builder> enaSupport) {
            return enaSupport(AttributeBooleanValue.builder().applyMutation(enaSupport).build());
        }

        /**
         * <p>
         * Replaces the security groups of the instance with the specified security groups. You must specify the ID of
         * at least one security group, even if it's just the default security group for the VPC.
         * </p>
         * 
         * @param groups
         *        Replaces the security groups of the instance with the specified security groups. You must specify the
         *        ID of at least one security group, even if it's just the default security group for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * Replaces the security groups of the instance with the specified security groups. You must specify the ID of
         * at least one security group, even if it's just the default security group for the VPC.
         * </p>
         * 
         * @param groups
         *        Replaces the security groups of the instance with the specified security groups. You must specify the
         *        ID of at least one security group, even if it's just the default security group for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInitiatedShutdownBehavior(AttributeValue instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceInitiatedShutdownBehavior(AttributeValue)}.
         * 
         * @param instanceInitiatedShutdownBehavior
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInitiatedShutdownBehavior(AttributeValue)
         */
        default Builder instanceInitiatedShutdownBehavior(Consumer<AttributeValue.Builder> instanceInitiatedShutdownBehavior) {
            return instanceInitiatedShutdownBehavior(AttributeValue.builder().applyMutation(instanceInitiatedShutdownBehavior)
                    .build());
        }

        /**
         * <p>
         * Changes the instance type to the specified value. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>. If the instance type is not valid, the error returned is
         * <code>InvalidInstanceAttributeValue</code>.
         * </p>
         * 
         * @param instanceType
         *        Changes the instance type to the specified value. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>. If the instance type is not valid, the error returned is
         *        <code>InvalidInstanceAttributeValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(AttributeValue instanceType);

        /**
         * <p>
         * Changes the instance type to the specified value. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>. If the instance type is not valid, the error returned is
         * <code>InvalidInstanceAttributeValue</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceType(AttributeValue)}.
         * 
         * @param instanceType
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceType(AttributeValue)
         */
        default Builder instanceType(Consumer<AttributeValue.Builder> instanceType) {
            return instanceType(AttributeValue.builder().applyMutation(instanceType).build());
        }

        /**
         * <p>
         * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels
         * and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * </p>
         * 
         * @param kernel
         *        Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of
         *        kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernel(AttributeValue kernel);

        /**
         * <p>
         * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels
         * and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #kernel(AttributeValue)}.
         * 
         * @param kernel
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernel(AttributeValue)
         */
        default Builder kernel(Consumer<AttributeValue.Builder> kernel) {
            return kernel(AttributeValue.builder().applyMutation(kernel).build());
        }

        /**
         * <p>
         * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels
         * and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * </p>
         * 
         * @param ramdisk
         *        Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of
         *        kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdisk(AttributeValue ramdisk);

        /**
         * <p>
         * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels
         * and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #ramdisk(AttributeValue)}.
         * 
         * @param ramdisk
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ramdisk(AttributeValue)
         */
        default Builder ramdisk(Consumer<AttributeValue.Builder> ramdisk) {
            return ramdisk(AttributeValue.builder().applyMutation(ramdisk).build());
        }

        /**
         * <p>
         * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for
         * the instance.
         * </p>
         * <p>
         * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
         * </p>
         * <p>
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         * unreachable.
         * </p>
         * 
         * @param sriovNetSupport
         *        Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function
         *        interface for the instance.</p>
         *        <p>
         *        There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this
         *        time.
         *        </p>
         *        <p>
         *        This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         *        unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(AttributeValue sriovNetSupport);

        /**
         * <p>
         * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for
         * the instance.
         * </p>
         * <p>
         * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
         * </p>
         * <p>
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         * unreachable.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #sriovNetSupport(AttributeValue)}.
         * 
         * @param sriovNetSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sriovNetSupport(AttributeValue)
         */
        default Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return sriovNetSupport(AttributeValue.builder().applyMutation(sriovNetSupport).build());
        }

        /**
         * <p>
         * Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or
         * command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise,
         * you must provide base64-encoded text.
         * </p>
         * 
         * @param userData
         *        Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK
         *        or command line tool, base64-encoding is performed for you, and you can load the text from a file.
         *        Otherwise, you must provide base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(BlobAttributeValue userData);

        /**
         * <p>
         * Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or
         * command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise,
         * you must provide base64-encoded text.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlobAttributeValue.Builder} avoiding the
         * need to create one manually via {@link BlobAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlobAttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #userData(BlobAttributeValue)}.
         * 
         * @param userData
         *        a consumer that will call methods on {@link BlobAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userData(BlobAttributeValue)
         */
        default Builder userData(Consumer<BlobAttributeValue.Builder> userData) {
            return userData(BlobAttributeValue.builder().applyMutation(userData).build());
        }

        /**
         * <p>
         * A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>,
         * <code>userData</code>, <code>disableApiTermination</code>, or <code>instanceInitiatedShutdownBehavior</code>
         * attribute.
         * </p>
         * 
         * @param value
         *        A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>,
         *        <code>userData</code>, <code>disableApiTermination</code>, or
         *        <code>instanceInitiatedShutdownBehavior</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Indicates whether an instance is enabled for stop protection. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop
         * Protection</a>.
         * </p>
         * <p/>
         * 
         * @param disableApiStop
         *        Indicates whether an instance is enabled for stop protection. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop
         *        Protection</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiStop(AttributeBooleanValue disableApiStop);

        /**
         * <p>
         * Indicates whether an instance is enabled for stop protection. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop
         * Protection</a>.
         * </p>
         * <p/>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #disableApiStop(AttributeBooleanValue)}.
         * 
         * @param disableApiStop
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disableApiStop(AttributeBooleanValue)
         */
        default Builder disableApiStop(Consumer<AttributeBooleanValue.Builder> disableApiStop) {
            return disableApiStop(AttributeBooleanValue.builder().applyMutation(disableApiStop).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private AttributeBooleanValue sourceDestCheck;

        private String attribute;

        private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private AttributeBooleanValue disableApiTermination;

        private AttributeBooleanValue ebsOptimized;

        private AttributeBooleanValue enaSupport;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String instanceId;

        private AttributeValue instanceInitiatedShutdownBehavior;

        private AttributeValue instanceType;

        private AttributeValue kernel;

        private AttributeValue ramdisk;

        private AttributeValue sriovNetSupport;

        private BlobAttributeValue userData;

        private String value;

        private AttributeBooleanValue disableApiStop;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceAttributeRequest model) {
            super(model);
            sourceDestCheck(model.sourceDestCheck);
            attribute(model.attribute);
            blockDeviceMappings(model.blockDeviceMappings);
            disableApiTermination(model.disableApiTermination);
            ebsOptimized(model.ebsOptimized);
            enaSupport(model.enaSupport);
            groups(model.groups);
            instanceId(model.instanceId);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            instanceType(model.instanceType);
            kernel(model.kernel);
            ramdisk(model.ramdisk);
            sriovNetSupport(model.sriovNetSupport);
            userData(model.userData);
            value(model.value);
            disableApiStop(model.disableApiStop);
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return sourceDestCheck != null ? sourceDestCheck.toBuilder() : null;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final List<InstanceBlockDeviceMappingSpecification.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMappingSpecification.Builder> result = InstanceBlockDeviceMappingSpecificationListCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(
                Collection<InstanceBlockDeviceMappingSpecification.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMappingSpecification.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMappingSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AttributeBooleanValue.Builder getDisableApiTermination() {
            return disableApiTermination != null ? disableApiTermination.toBuilder() : null;
        }

        public final void setDisableApiTermination(AttributeBooleanValue.BuilderImpl disableApiTermination) {
            this.disableApiTermination = disableApiTermination != null ? disableApiTermination.build() : null;
        }

        @Override
        public final Builder disableApiTermination(AttributeBooleanValue disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final AttributeBooleanValue.Builder getEbsOptimized() {
            return ebsOptimized != null ? ebsOptimized.toBuilder() : null;
        }

        public final void setEbsOptimized(AttributeBooleanValue.BuilderImpl ebsOptimized) {
            this.ebsOptimized = ebsOptimized != null ? ebsOptimized.build() : null;
        }

        @Override
        public final Builder ebsOptimized(AttributeBooleanValue ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnaSupport() {
            return enaSupport != null ? enaSupport.toBuilder() : null;
        }

        public final void setEnaSupport(AttributeBooleanValue.BuilderImpl enaSupport) {
            this.enaSupport = enaSupport != null ? enaSupport.build() : null;
        }

        @Override
        public final Builder enaSupport(AttributeBooleanValue enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final AttributeValue.Builder getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior != null ? instanceInitiatedShutdownBehavior.toBuilder() : null;
        }

        public final void setInstanceInitiatedShutdownBehavior(AttributeValue.BuilderImpl instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior != null ? instanceInitiatedShutdownBehavior
                    .build() : null;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(AttributeValue instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final AttributeValue.Builder getInstanceType() {
            return instanceType != null ? instanceType.toBuilder() : null;
        }

        public final void setInstanceType(AttributeValue.BuilderImpl instanceType) {
            this.instanceType = instanceType != null ? instanceType.build() : null;
        }

        @Override
        public final Builder instanceType(AttributeValue instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final AttributeValue.Builder getKernel() {
            return kernel != null ? kernel.toBuilder() : null;
        }

        public final void setKernel(AttributeValue.BuilderImpl kernel) {
            this.kernel = kernel != null ? kernel.build() : null;
        }

        @Override
        public final Builder kernel(AttributeValue kernel) {
            this.kernel = kernel;
            return this;
        }

        public final AttributeValue.Builder getRamdisk() {
            return ramdisk != null ? ramdisk.toBuilder() : null;
        }

        public final void setRamdisk(AttributeValue.BuilderImpl ramdisk) {
            this.ramdisk = ramdisk != null ? ramdisk.build() : null;
        }

        @Override
        public final Builder ramdisk(AttributeValue ramdisk) {
            this.ramdisk = ramdisk;
            return this;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return sriovNetSupport != null ? sriovNetSupport.toBuilder() : null;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final BlobAttributeValue.Builder getUserData() {
            return userData != null ? userData.toBuilder() : null;
        }

        public final void setUserData(BlobAttributeValue.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public final Builder userData(BlobAttributeValue userData) {
            this.userData = userData;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final AttributeBooleanValue.Builder getDisableApiStop() {
            return disableApiStop != null ? disableApiStop.toBuilder() : null;
        }

        public final void setDisableApiStop(AttributeBooleanValue.BuilderImpl disableApiStop) {
            this.disableApiStop = disableApiStop != null ? disableApiStop.build() : null;
        }

        @Override
        public final Builder disableApiStop(AttributeBooleanValue disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceAttributeRequest build() {
            return new ModifyInstanceAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
