/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.RuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkAclEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkAclEntry> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkAclEntry.getter(NetworkAclEntry::cidrBlock)).setter(NetworkAclEntry.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<Boolean> EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(NetworkAclEntry.getter(NetworkAclEntry::egress)).setter(NetworkAclEntry.setter(Builder::egress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").unmarshallLocationName("egress").build()}).build();
    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NetworkAclEntry.getter(NetworkAclEntry::icmpTypeCode)).setter(NetworkAclEntry.setter(Builder::icmpTypeCode)).constructor(IcmpTypeCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IcmpTypeCode").unmarshallLocationName("icmpTypeCode").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkAclEntry.getter(NetworkAclEntry::ipv6CidrBlock)).setter(NetworkAclEntry.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("ipv6CidrBlock").build()}).build();
    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NetworkAclEntry.getter(NetworkAclEntry::portRange)).setter(NetworkAclEntry.setter(Builder::portRange)).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").unmarshallLocationName("portRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkAclEntry.getter(NetworkAclEntry::protocol)).setter(NetworkAclEntry.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkAclEntry.getter(NetworkAclEntry::ruleActionAsString)).setter(NetworkAclEntry.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("ruleAction").build()}).build();
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(NetworkAclEntry.getter(NetworkAclEntry::ruleNumber)).setter(NetworkAclEntry.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").unmarshallLocationName("ruleNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, EGRESS_FIELD, ICMP_TYPE_CODE_FIELD, IPV6_CIDR_BLOCK_FIELD, PORT_RANGE_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, RULE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidrBlock;
    private final Boolean egress;
    private final IcmpTypeCode icmpTypeCode;
    private final String ipv6CidrBlock;
    private final PortRange portRange;
    private final String protocol;
    private final String ruleAction;
    private final Integer ruleNumber;

    private NetworkAclEntry(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean egress() {
        return this.egress;
    }

    public IcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public PortRange portRange() {
        return this.portRange;
    }

    public String protocol() {
        return this.protocol;
    }

    public RuleAction ruleAction() {
        return RuleAction.fromValue(this.ruleAction);
    }

    public String ruleActionAsString() {
        return this.ruleAction;
    }

    public Integer ruleNumber() {
        return this.ruleNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        hashCode = 31 * hashCode + Objects.hashCode(this.icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclEntry)) {
            return false;
        }
        NetworkAclEntry other = (NetworkAclEntry)obj;
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.egress(), other.egress()) && Objects.equals(this.icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.portRange(), other.portRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.ruleNumber(), other.ruleNumber());
    }

    public String toString() {
        return ToString.builder((String)"NetworkAclEntry").add("CidrBlock", (Object)this.cidrBlock()).add("Egress", (Object)this.egress()).add("IcmpTypeCode", (Object)this.icmpTypeCode()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("PortRange", (Object)this.portRange()).add("Protocol", (Object)this.protocol()).add("RuleAction", (Object)this.ruleActionAsString()).add("RuleNumber", (Object)this.ruleNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Egress": {
                return Optional.ofNullable(clazz.cast(this.egress()));
            }
            case "IcmpTypeCode": {
                return Optional.ofNullable(clazz.cast(this.icmpTypeCode()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "PortRange": {
                return Optional.ofNullable(clazz.cast(this.portRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "RuleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAclEntry, T> g) {
        return obj -> g.apply((NetworkAclEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean egress;
        private IcmpTypeCode icmpTypeCode;
        private String ipv6CidrBlock;
        private PortRange portRange;
        private String protocol;
        private String ruleAction;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclEntry model) {
            this.cidrBlock(model.cidrBlock);
            this.egress(model.egress);
            this.icmpTypeCode(model.icmpTypeCode);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.portRange(model.portRange);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return this.icmpTypeCode != null ? this.icmpTypeCode.toBuilder() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final PortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public NetworkAclEntry build() {
            return new NetworkAclEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkAclEntry> {
        public Builder cidrBlock(String var1);

        public Builder egress(Boolean var1);

        public Builder icmpTypeCode(IcmpTypeCode var1);

        default public Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return this.icmpTypeCode((IcmpTypeCode)((IcmpTypeCode.Builder)IcmpTypeCode.builder().applyMutation(icmpTypeCode)).build());
        }

        public Builder ipv6CidrBlock(String var1);

        public Builder portRange(PortRange var1);

        default public Builder portRange(Consumer<PortRange.Builder> portRange) {
            return this.portRange((PortRange)((PortRange.Builder)PortRange.builder().applyMutation(portRange)).build());
        }

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(RuleAction var1);

        public Builder ruleNumber(Integer var1);
    }
}

