/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.HostRecovery;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyHostsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyHostsRequest> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoPlacement").getter(ModifyHostsRequest.getter(ModifyHostsRequest::autoPlacementAsString)).setter(ModifyHostsRequest.setter(Builder::autoPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement").unmarshallLocationName("autoPlacement").build()}).build();
    private static final SdkField<List<String>> HOST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostIds").getter(ModifyHostsRequest.getter(ModifyHostsRequest::hostIds)).setter(ModifyHostsRequest.setter(Builder::hostIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostRecovery").getter(ModifyHostsRequest.getter(ModifyHostsRequest::hostRecoveryAsString)).setter(ModifyHostsRequest.setter(Builder::hostRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRecovery").unmarshallLocationName("HostRecovery").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ModifyHostsRequest.getter(ModifyHostsRequest::instanceType)).setter(ModifyHostsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(ModifyHostsRequest.getter(ModifyHostsRequest::instanceFamily)).setter(ModifyHostsRequest.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("InstanceFamily").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD, HOST_IDS_FIELD, HOST_RECOVERY_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_FAMILY_FIELD));
    private final String autoPlacement;
    private final List<String> hostIds;
    private final String hostRecovery;
    private final String instanceType;
    private final String instanceFamily;

    private ModifyHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.hostIds = builder.hostIds;
        this.hostRecovery = builder.hostRecovery;
        this.instanceType = builder.instanceType;
        this.instanceFamily = builder.instanceFamily;
    }

    public final AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public final String autoPlacementAsString() {
        return this.autoPlacement;
    }

    public final boolean hasHostIds() {
        return this.hostIds != null && !(this.hostIds instanceof SdkAutoConstructList);
    }

    public final List<String> hostIds() {
        return this.hostIds;
    }

    public final HostRecovery hostRecovery() {
        return HostRecovery.fromValue(this.hostRecovery);
    }

    public final String hostRecoveryAsString() {
        return this.hostRecovery;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostIds() ? this.hostIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest)((Object)obj);
        return Objects.equals(this.autoPlacementAsString(), other.autoPlacementAsString()) && this.hasHostIds() == other.hasHostIds() && Objects.equals(this.hostIds(), other.hostIds()) && Objects.equals(this.hostRecoveryAsString(), other.hostRecoveryAsString()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceFamily(), other.instanceFamily());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyHostsRequest").add("AutoPlacement", (Object)this.autoPlacementAsString()).add("HostIds", this.hasHostIds() ? this.hostIds() : null).add("HostRecovery", (Object)this.hostRecoveryAsString()).add("InstanceType", (Object)this.instanceType()).add("InstanceFamily", (Object)this.instanceFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.ofNullable(clazz.cast(this.autoPlacementAsString()));
            }
            case "HostIds": {
                return Optional.ofNullable(clazz.cast(this.hostIds()));
            }
            case "HostRecovery": {
                return Optional.ofNullable(clazz.cast(this.hostRecoveryAsString()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyHostsRequest, T> g) {
        return obj -> g.apply((ModifyHostsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String autoPlacement;
        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();
        private String hostRecovery;
        private String instanceType;
        private String instanceFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsRequest model) {
            super(model);
            this.autoPlacement(model.autoPlacement);
            this.hostIds(model.hostIds);
            this.hostRecovery(model.hostRecovery);
            this.instanceType(model.instanceType);
            this.instanceFamily(model.instanceFamily);
        }

        public final String getAutoPlacement() {
            return this.autoPlacement;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement == null ? null : autoPlacement.toString());
            return this;
        }

        public final Collection<String> getHostIds() {
            if (this.hostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hostIds;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final String getHostRecovery() {
            return this.hostRecovery;
        }

        public final void setHostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
        }

        @Override
        public final Builder hostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        @Override
        public final Builder hostRecovery(HostRecovery hostRecovery) {
            this.hostRecovery(hostRecovery == null ? null : hostRecovery.toString());
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHostsRequest build() {
            return new ModifyHostsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyHostsRequest> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);

        public Builder hostRecovery(String var1);

        public Builder hostRecovery(HostRecovery var1);

        public Builder instanceType(String var1);

        public Builder instanceFamily(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

