/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConsoleScreenshotResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetConsoleScreenshotResponse> {
    private static final SdkField<String> IMAGE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageData").getter(GetConsoleScreenshotResponse.getter(GetConsoleScreenshotResponse::imageData)).setter(GetConsoleScreenshotResponse.setter(Builder::imageData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageData").unmarshallLocationName("imageData").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetConsoleScreenshotResponse.getter(GetConsoleScreenshotResponse::instanceId)).setter(GetConsoleScreenshotResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DATA_FIELD, INSTANCE_ID_FIELD));
    private final String imageData;
    private final String instanceId;

    private GetConsoleScreenshotResponse(BuilderImpl builder) {
        super(builder);
        this.imageData = builder.imageData;
        this.instanceId = builder.instanceId;
    }

    public final String imageData() {
        return this.imageData;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageData());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotResponse)) {
            return false;
        }
        GetConsoleScreenshotResponse other = (GetConsoleScreenshotResponse)((Object)obj);
        return Objects.equals(this.imageData(), other.imageData()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetConsoleScreenshotResponse").add("ImageData", (Object)this.imageData()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageData": {
                return Optional.ofNullable(clazz.cast(this.imageData()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConsoleScreenshotResponse, T> g) {
        return obj -> g.apply((GetConsoleScreenshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String imageData;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotResponse model) {
            super(model);
            this.imageData(model.imageData);
            this.instanceId(model.instanceId);
        }

        public final String getImageData() {
            return this.imageData;
        }

        public final void setImageData(String imageData) {
            this.imageData = imageData;
        }

        @Override
        public final Builder imageData(String imageData) {
            this.imageData = imageData;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public GetConsoleScreenshotResponse build() {
            return new GetConsoleScreenshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConsoleScreenshotResponse> {
        public Builder imageData(String var1);

        public Builder instanceId(String var1);
    }
}

