/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AssociationStatus;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetNetwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetNetwork> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(TargetNetwork.getter(TargetNetwork::associationId)).setter(TargetNetwork.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(TargetNetwork.getter(TargetNetwork::vpcId)).setter(TargetNetwork.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> TARGET_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetNetworkId").getter(TargetNetwork.getter(TargetNetwork::targetNetworkId)).setter(TargetNetwork.setter(Builder::targetNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNetworkId").unmarshallLocationName("targetNetworkId").build()}).build();
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(TargetNetwork.getter(TargetNetwork::clientVpnEndpointId)).setter(TargetNetwork.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<AssociationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(TargetNetwork.getter(TargetNetwork::status)).setter(TargetNetwork.setter(Builder::status)).constructor(AssociationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(TargetNetwork.getter(TargetNetwork::securityGroups)).setter(TargetNetwork.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").unmarshallLocationName("securityGroups").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, VPC_ID_FIELD, TARGET_NETWORK_ID_FIELD, CLIENT_VPN_ENDPOINT_ID_FIELD, STATUS_FIELD, SECURITY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String vpcId;
    private final String targetNetworkId;
    private final String clientVpnEndpointId;
    private final AssociationStatus status;
    private final List<String> securityGroups;

    private TargetNetwork(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.vpcId = builder.vpcId;
        this.targetNetworkId = builder.targetNetworkId;
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.status = builder.status;
        this.securityGroups = builder.securityGroups;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String targetNetworkId() {
        return this.targetNetworkId;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final AssociationStatus status() {
        return this.status;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetNetwork)) {
            return false;
        }
        TargetNetwork other = (TargetNetwork)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.targetNetworkId(), other.targetNetworkId()) && Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.status(), other.status()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"TargetNetwork").add("AssociationId", (Object)this.associationId()).add("VpcId", (Object)this.vpcId()).add("TargetNetworkId", (Object)this.targetNetworkId()).add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Status", (Object)this.status()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "TargetNetworkId": {
                return Optional.ofNullable(clazz.cast(this.targetNetworkId()));
            }
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetNetwork, T> g) {
        return obj -> g.apply((TargetNetwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String vpcId;
        private String targetNetworkId;
        private String clientVpnEndpointId;
        private AssociationStatus status;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TargetNetwork model) {
            this.associationId(model.associationId);
            this.vpcId(model.vpcId);
            this.targetNetworkId(model.targetNetworkId);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.status(model.status);
            this.securityGroups(model.securityGroups);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getTargetNetworkId() {
            return this.targetNetworkId;
        }

        public final void setTargetNetworkId(String targetNetworkId) {
            this.targetNetworkId = targetNetworkId;
        }

        @Override
        @Transient
        public final Builder targetNetworkId(String targetNetworkId) {
            this.targetNetworkId = targetNetworkId;
            return this;
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        @Transient
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final AssociationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(AssociationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(AssociationStatus status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public TargetNetwork build() {
            return new TargetNetwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetNetwork> {
        public Builder associationId(String var1);

        public Builder vpcId(String var1);

        public Builder targetNetworkId(String var1);

        public Builder clientVpnEndpointId(String var1);

        public Builder status(AssociationStatus var1);

        default public Builder status(Consumer<AssociationStatus.Builder> status) {
            return this.status((AssociationStatus)((AssociationStatus.Builder)AssociationStatus.builder().applyMutation(status)).build());
        }

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

