/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceBlockDeviceMappingSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceBlockDeviceMappingSpecification> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(InstanceBlockDeviceMappingSpecification.getter(InstanceBlockDeviceMappingSpecification::deviceName)).setter(InstanceBlockDeviceMappingSpecification.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").unmarshallLocationName("deviceName").build()}).build();
    private static final SdkField<EbsInstanceBlockDeviceSpecification> EBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ebs").getter(InstanceBlockDeviceMappingSpecification.getter(InstanceBlockDeviceMappingSpecification::ebs)).setter(InstanceBlockDeviceMappingSpecification.setter(Builder::ebs)).constructor(EbsInstanceBlockDeviceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").unmarshallLocationName("ebs").build()}).build();
    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NoDevice").getter(InstanceBlockDeviceMappingSpecification.getter(InstanceBlockDeviceMappingSpecification::noDevice)).setter(InstanceBlockDeviceMappingSpecification.setter(Builder::noDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").unmarshallLocationName("noDevice").build()}).build();
    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VirtualName").getter(InstanceBlockDeviceMappingSpecification.getter(InstanceBlockDeviceMappingSpecification::virtualName)).setter(InstanceBlockDeviceMappingSpecification.setter(Builder::virtualName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").unmarshallLocationName("virtualName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD, NO_DEVICE_FIELD, VIRTUAL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final EbsInstanceBlockDeviceSpecification ebs;
    private final String noDevice;
    private final String virtualName;

    private InstanceBlockDeviceMappingSpecification(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final EbsInstanceBlockDeviceSpecification ebs() {
        return this.ebs;
    }

    public final String noDevice() {
        return this.noDevice;
    }

    public final String virtualName() {
        return this.virtualName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMappingSpecification)) {
            return false;
        }
        InstanceBlockDeviceMappingSpecification other = (InstanceBlockDeviceMappingSpecification)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.ebs(), other.ebs()) && Objects.equals(this.noDevice(), other.noDevice()) && Objects.equals(this.virtualName(), other.virtualName());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceBlockDeviceMappingSpecification").add("DeviceName", (Object)this.deviceName()).add("Ebs", (Object)this.ebs()).add("NoDevice", (Object)this.noDevice()).add("VirtualName", (Object)this.virtualName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Ebs": {
                return Optional.ofNullable(clazz.cast(this.ebs()));
            }
            case "NoDevice": {
                return Optional.ofNullable(clazz.cast(this.noDevice()));
            }
            case "VirtualName": {
                return Optional.ofNullable(clazz.cast(this.virtualName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceBlockDeviceMappingSpecification, T> g) {
        return obj -> g.apply((InstanceBlockDeviceMappingSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private EbsInstanceBlockDeviceSpecification ebs;
        private String noDevice;
        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMappingSpecification model) {
            this.deviceName(model.deviceName);
            this.ebs(model.ebs);
            this.noDevice(model.noDevice);
            this.virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        @Transient
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final EbsInstanceBlockDeviceSpecification.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        public final void setEbs(EbsInstanceBlockDeviceSpecification.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        @Transient
        public final Builder ebs(EbsInstanceBlockDeviceSpecification ebs) {
            this.ebs = ebs;
            return this;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        @Transient
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        @Transient
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public InstanceBlockDeviceMappingSpecification build() {
            return new InstanceBlockDeviceMappingSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceBlockDeviceMappingSpecification> {
        public Builder deviceName(String var1);

        public Builder ebs(EbsInstanceBlockDeviceSpecification var1);

        default public Builder ebs(Consumer<EbsInstanceBlockDeviceSpecification.Builder> ebs) {
            return this.ebs((EbsInstanceBlockDeviceSpecification)((EbsInstanceBlockDeviceSpecification.Builder)EbsInstanceBlockDeviceSpecification.builder().applyMutation(ebs)).build());
        }

        public Builder noDevice(String var1);

        public Builder virtualName(String var1);
    }
}

