/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRule;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeSecurityGroupIngressResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AuthorizeSecurityGroupIngressResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Return").getter(AuthorizeSecurityGroupIngressResponse.getter(AuthorizeSecurityGroupIngressResponse::returnValue)).setter(AuthorizeSecurityGroupIngressResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final SdkField<List<SecurityGroupRule>> SECURITY_GROUP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupRules").getter(AuthorizeSecurityGroupIngressResponse.getter(AuthorizeSecurityGroupIngressResponse::securityGroupRules)).setter(AuthorizeSecurityGroupIngressResponse.setter(Builder::securityGroupRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleSet").unmarshallLocationName("securityGroupRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD, SECURITY_GROUP_RULES_FIELD));
    private final Boolean returnValue;
    private final List<SecurityGroupRule> securityGroupRules;

    private AuthorizeSecurityGroupIngressResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.securityGroupRules = builder.securityGroupRules;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final boolean hasSecurityGroupRules() {
        return this.securityGroupRules != null && !(this.securityGroupRules instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupRule> securityGroupRules() {
        return this.securityGroupRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupRules() ? this.securityGroupRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupIngressResponse)) {
            return false;
        }
        AuthorizeSecurityGroupIngressResponse other = (AuthorizeSecurityGroupIngressResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && this.hasSecurityGroupRules() == other.hasSecurityGroupRules() && Objects.equals(this.securityGroupRules(), other.securityGroupRules());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeSecurityGroupIngressResponse").add("Return", (Object)this.returnValue()).add("SecurityGroupRules", this.hasSecurityGroupRules() ? this.securityGroupRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Return": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "SecurityGroupRules": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeSecurityGroupIngressResponse, T> g) {
        return obj -> g.apply((AuthorizeSecurityGroupIngressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private List<SecurityGroupRule> securityGroupRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupIngressResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.securityGroupRules(model.securityGroupRules);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        @Transient
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<SecurityGroupRule.Builder> getSecurityGroupRules() {
            List<SecurityGroupRule.Builder> result = SecurityGroupRuleListCopier.copyToBuilder(this.securityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRules(Collection<SecurityGroupRule.BuilderImpl> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copyFromBuilder(securityGroupRules);
        }

        @Override
        @Transient
        public final Builder securityGroupRules(Collection<SecurityGroupRule> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copy(securityGroupRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRules(SecurityGroupRule ... securityGroupRules) {
            this.securityGroupRules(Arrays.asList(securityGroupRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRules(Consumer<SecurityGroupRule.Builder> ... securityGroupRules) {
            this.securityGroupRules(Stream.of(securityGroupRules).map(c -> (SecurityGroupRule)((SecurityGroupRule.Builder)SecurityGroupRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AuthorizeSecurityGroupIngressResponse build() {
            return new AuthorizeSecurityGroupIngressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeSecurityGroupIngressResponse> {
        public Builder returnValue(Boolean var1);

        public Builder securityGroupRules(Collection<SecurityGroupRule> var1);

        public Builder securityGroupRules(SecurityGroupRule ... var1);

        public Builder securityGroupRules(Consumer<SecurityGroupRule.Builder> ... var1);
    }
}

