/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoring;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, MonitorInstancesResponse> {
    private static final SdkField<List<InstanceMonitoring>> INSTANCE_MONITORINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceMonitorings").getter(MonitorInstancesResponse.getter(MonitorInstancesResponse::instanceMonitorings)).setter(MonitorInstancesResponse.setter(Builder::instanceMonitorings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet").unmarshallLocationName("instancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_MONITORINGS_FIELD));
    private final List<InstanceMonitoring> instanceMonitorings;

    private MonitorInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    public final boolean hasInstanceMonitorings() {
        return this.instanceMonitorings != null && !(this.instanceMonitorings instanceof SdkAutoConstructList);
    }

    public final List<InstanceMonitoring> instanceMonitorings() {
        return this.instanceMonitorings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceMonitorings() ? this.instanceMonitorings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorInstancesResponse)) {
            return false;
        }
        MonitorInstancesResponse other = (MonitorInstancesResponse)((Object)obj);
        return this.hasInstanceMonitorings() == other.hasInstanceMonitorings() && Objects.equals(this.instanceMonitorings(), other.instanceMonitorings());
    }

    public final String toString() {
        return ToString.builder((String)"MonitorInstancesResponse").add("InstanceMonitorings", this.hasInstanceMonitorings() ? this.instanceMonitorings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceMonitorings": {
                return Optional.ofNullable(clazz.cast(this.instanceMonitorings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitorInstancesResponse, T> g) {
        return obj -> g.apply((MonitorInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceMonitoring> instanceMonitorings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorInstancesResponse model) {
            super(model);
            this.instanceMonitorings(model.instanceMonitorings);
        }

        public final List<InstanceMonitoring.Builder> getInstanceMonitorings() {
            List<InstanceMonitoring.Builder> result = InstanceMonitoringListCopier.copyToBuilder(this.instanceMonitorings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring ... instanceMonitorings) {
            this.instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder> ... instanceMonitorings) {
            this.instanceMonitorings(Stream.of(instanceMonitorings).map(c -> (InstanceMonitoring)((InstanceMonitoring.Builder)InstanceMonitoring.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        @Override
        public MonitorInstancesResponse build() {
            return new MonitorInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MonitorInstancesResponse> {
        public Builder instanceMonitorings(Collection<InstanceMonitoring> var1);

        public Builder instanceMonitorings(InstanceMonitoring ... var1);

        public Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder> ... var1);
    }
}

