/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.ProductCodeStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyImageAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyImageAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::attribute)).setter(ModifyImageAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("Attribute").build()}).build();
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Description").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::description)).setter(ModifyImageAttributeRequest.setter(Builder::description)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::imageId)).setter(ModifyImageAttributeRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<LaunchPermissionModifications> LAUNCH_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchPermission").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::launchPermission)).setter(ModifyImageAttributeRequest.setter(Builder::launchPermission)).constructor(LaunchPermissionModifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission").unmarshallLocationName("LaunchPermission").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationType").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::operationTypeAsString)).setter(ModifyImageAttributeRequest.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType").unmarshallLocationName("OperationType").build()}).build();
    private static final SdkField<List<String>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::productCodes)).setter(ModifyImageAttributeRequest.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").unmarshallLocationName("ProductCode").build(), ListTrait.builder().memberLocationName("ProductCode").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").unmarshallLocationName("ProductCode").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroups").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::userGroups)).setter(ModifyImageAttributeRequest.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").unmarshallLocationName("UserGroup").build(), ListTrait.builder().memberLocationName("UserGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").unmarshallLocationName("UserGroup").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIds").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::userIds)).setter(ModifyImageAttributeRequest.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("UserId").build(), ListTrait.builder().memberLocationName("UserId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("UserId").build()}).build()).build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(ModifyImageAttributeRequest.getter(ModifyImageAttributeRequest::value)).setter(ModifyImageAttributeRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").unmarshallLocationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, DESCRIPTION_FIELD, IMAGE_ID_FIELD, LAUNCH_PERMISSION_FIELD, OPERATION_TYPE_FIELD, PRODUCT_CODES_FIELD, USER_GROUPS_FIELD, USER_IDS_FIELD, VALUE_FIELD));
    private final String attribute;
    private final AttributeValue description;
    private final String imageId;
    private final LaunchPermissionModifications launchPermission;
    private final String operationType;
    private final List<String> productCodes;
    private final List<String> userGroups;
    private final List<String> userIds;
    private final String value;

    private ModifyImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.launchPermission = builder.launchPermission;
        this.operationType = builder.operationType;
        this.productCodes = builder.productCodes;
        this.userGroups = builder.userGroups;
        this.userIds = builder.userIds;
        this.value = builder.value;
    }

    public final String attribute() {
        return this.attribute;
    }

    public final AttributeValue description() {
        return this.description;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final LaunchPermissionModifications launchPermission() {
        return this.launchPermission;
    }

    public final OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<String> productCodes() {
        return this.productCodes;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<String> userGroups() {
        return this.userGroups;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final String value() {
        return this.value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest)((Object)obj);
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.launchPermission(), other.launchPermission()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups()) && this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyImageAttributeRequest").add("Attribute", (Object)this.attribute()).add("Description", (Object)this.description()).add("ImageId", (Object)this.imageId()).add("LaunchPermission", (Object)this.launchPermission()).add("OperationType", (Object)this.operationTypeAsString()).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).add("UserIds", this.hasUserIds() ? this.userIds() : null).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "LaunchPermission": {
                return Optional.ofNullable(clazz.cast(this.launchPermission()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "UserGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyImageAttributeRequest, T> g) {
        return obj -> g.apply((ModifyImageAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String attribute;
        private AttributeValue description;
        private String imageId;
        private LaunchPermissionModifications launchPermission;
        private String operationType;
        private List<String> productCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyImageAttributeRequest model) {
            super(model);
            this.attribute(model.attribute);
            this.description(model.description);
            this.imageId(model.imageId);
            this.launchPermission(model.launchPermission);
            this.operationType(model.operationType);
            this.productCodes(model.productCodes);
            this.userGroups(model.userGroups);
            this.userIds(model.userIds);
            this.value(model.value);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        @Transient
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final AttributeValue.Builder getDescription() {
            return this.description != null ? this.description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        @Transient
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final LaunchPermissionModifications.Builder getLaunchPermission() {
            return this.launchPermission != null ? this.launchPermission.toBuilder() : null;
        }

        public final void setLaunchPermission(LaunchPermissionModifications.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        @Override
        @Transient
        public final Builder launchPermission(LaunchPermissionModifications launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        @Transient
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        @Transient
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final Collection<String> getProductCodes() {
            if (this.productCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productCodes;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        @Override
        @Transient
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productCodes(String ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (this.userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        @Override
        @Transient
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @Override
        @Transient
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyImageAttributeRequest build() {
            return new ModifyImageAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyImageAttributeRequest> {
        public Builder attribute(String var1);

        public Builder description(AttributeValue var1);

        default public Builder description(Consumer<AttributeValue.Builder> description) {
            return this.description((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(description)).build());
        }

        public Builder imageId(String var1);

        public Builder launchPermission(LaunchPermissionModifications var1);

        default public Builder launchPermission(Consumer<LaunchPermissionModifications.Builder> launchPermission) {
            return this.launchPermission((LaunchPermissionModifications)((LaunchPermissionModifications.Builder)LaunchPermissionModifications.builder().applyMutation(launchPermission)).build());
        }

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder productCodes(Collection<String> var1);

        public Builder productCodes(String ... var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder value(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

