/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse;
import software.amazon.awssdk.services.ec2.model.IpamScope;

public class DescribeIpamScopesPublisher
implements SdkPublisher<DescribeIpamScopesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamScopesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamScopesPublisher(Ec2AsyncClient client, DescribeIpamScopesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamScopesPublisher(Ec2AsyncClient client, DescribeIpamScopesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamScopesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamScopesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamScope> ipamScopes() {
        Function<DescribeIpamScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamScopes() != null) {
                return response.ipamScopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeIpamScopesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeIpamScopesResponseFetcher
    implements AsyncPageFetcher<DescribeIpamScopesResponse> {
        private DescribeIpamScopesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamScopesResponse> nextPage(DescribeIpamScopesResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamScopesPublisher.this.client.describeIpamScopes(DescribeIpamScopesPublisher.this.firstRequest);
            }
            return DescribeIpamScopesPublisher.this.client.describeIpamScopes((DescribeIpamScopesRequest)((Object)DescribeIpamScopesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

