/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue;
import software.amazon.awssdk.services.ec2.model.DnsSupportValue;
import software.amazon.awssdk.services.ec2.model.Ipv6SupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayVpcAttachmentRequestOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateTransitGatewayVpcAttachmentRequestOptions> {
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsSupport").getter(CreateTransitGatewayVpcAttachmentRequestOptions.getter(CreateTransitGatewayVpcAttachmentRequestOptions::dnsSupportAsString)).setter(CreateTransitGatewayVpcAttachmentRequestOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").unmarshallLocationName("DnsSupport").build()}).build();
    private static final SdkField<String> IPV6_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Support").getter(CreateTransitGatewayVpcAttachmentRequestOptions.getter(CreateTransitGatewayVpcAttachmentRequestOptions::ipv6SupportAsString)).setter(CreateTransitGatewayVpcAttachmentRequestOptions.setter(Builder::ipv6Support)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Support").unmarshallLocationName("Ipv6Support").build()}).build();
    private static final SdkField<String> APPLIANCE_MODE_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplianceModeSupport").getter(CreateTransitGatewayVpcAttachmentRequestOptions.getter(CreateTransitGatewayVpcAttachmentRequestOptions::applianceModeSupportAsString)).setter(CreateTransitGatewayVpcAttachmentRequestOptions.setter(Builder::applianceModeSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplianceModeSupport").unmarshallLocationName("ApplianceModeSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_SUPPORT_FIELD, IPV6_SUPPORT_FIELD, APPLIANCE_MODE_SUPPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dnsSupport;
    private final String ipv6Support;
    private final String applianceModeSupport;

    private CreateTransitGatewayVpcAttachmentRequestOptions(BuilderImpl builder) {
        this.dnsSupport = builder.dnsSupport;
        this.ipv6Support = builder.ipv6Support;
        this.applianceModeSupport = builder.applianceModeSupport;
    }

    public final DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(this.dnsSupport);
    }

    public final String dnsSupportAsString() {
        return this.dnsSupport;
    }

    public final Ipv6SupportValue ipv6Support() {
        return Ipv6SupportValue.fromValue(this.ipv6Support);
    }

    public final String ipv6SupportAsString() {
        return this.ipv6Support;
    }

    public final ApplianceModeSupportValue applianceModeSupport() {
        return ApplianceModeSupportValue.fromValue(this.applianceModeSupport);
    }

    public final String applianceModeSupportAsString() {
        return this.applianceModeSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6SupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applianceModeSupportAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayVpcAttachmentRequestOptions)) {
            return false;
        }
        CreateTransitGatewayVpcAttachmentRequestOptions other = (CreateTransitGatewayVpcAttachmentRequestOptions)obj;
        return Objects.equals(this.dnsSupportAsString(), other.dnsSupportAsString()) && Objects.equals(this.ipv6SupportAsString(), other.ipv6SupportAsString()) && Objects.equals(this.applianceModeSupportAsString(), other.applianceModeSupportAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayVpcAttachmentRequestOptions").add("DnsSupport", (Object)this.dnsSupportAsString()).add("Ipv6Support", (Object)this.ipv6SupportAsString()).add("ApplianceModeSupport", (Object)this.applianceModeSupportAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupportAsString()));
            }
            case "Ipv6Support": {
                return Optional.ofNullable(clazz.cast(this.ipv6SupportAsString()));
            }
            case "ApplianceModeSupport": {
                return Optional.ofNullable(clazz.cast(this.applianceModeSupportAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayVpcAttachmentRequestOptions, T> g) {
        return obj -> g.apply((CreateTransitGatewayVpcAttachmentRequestOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dnsSupport;
        private String ipv6Support;
        private String applianceModeSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayVpcAttachmentRequestOptions model) {
            this.dnsSupport(model.dnsSupport);
            this.ipv6Support(model.ipv6Support);
            this.applianceModeSupport(model.applianceModeSupport);
        }

        public final String getDnsSupport() {
            return this.dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final String getIpv6Support() {
            return this.ipv6Support;
        }

        public final void setIpv6Support(String ipv6Support) {
            this.ipv6Support = ipv6Support;
        }

        @Override
        public final Builder ipv6Support(String ipv6Support) {
            this.ipv6Support = ipv6Support;
            return this;
        }

        @Override
        public final Builder ipv6Support(Ipv6SupportValue ipv6Support) {
            this.ipv6Support(ipv6Support == null ? null : ipv6Support.toString());
            return this;
        }

        public final String getApplianceModeSupport() {
            return this.applianceModeSupport;
        }

        public final void setApplianceModeSupport(String applianceModeSupport) {
            this.applianceModeSupport = applianceModeSupport;
        }

        @Override
        public final Builder applianceModeSupport(String applianceModeSupport) {
            this.applianceModeSupport = applianceModeSupport;
            return this;
        }

        @Override
        public final Builder applianceModeSupport(ApplianceModeSupportValue applianceModeSupport) {
            this.applianceModeSupport(applianceModeSupport == null ? null : applianceModeSupport.toString());
            return this;
        }

        public CreateTransitGatewayVpcAttachmentRequestOptions build() {
            return new CreateTransitGatewayVpcAttachmentRequestOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayVpcAttachmentRequestOptions> {
        public Builder dnsSupport(String var1);

        public Builder dnsSupport(DnsSupportValue var1);

        public Builder ipv6Support(String var1);

        public Builder ipv6Support(Ipv6SupportValue var1);

        public Builder applianceModeSupport(String var1);

        public Builder applianceModeSupport(ApplianceModeSupportValue var1);
    }
}

