/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPasswordDataResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetPasswordDataResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetPasswordDataResponse.getter(GetPasswordDataResponse::instanceId)).setter(GetPasswordDataResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> PASSWORD_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PasswordData").getter(GetPasswordDataResponse.getter(GetPasswordDataResponse::passwordData)).setter(GetPasswordDataResponse.setter(Builder::passwordData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordData").unmarshallLocationName("passwordData").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(GetPasswordDataResponse.getter(GetPasswordDataResponse::timestamp)).setter(GetPasswordDataResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PASSWORD_DATA_FIELD, TIMESTAMP_FIELD));
    private final String instanceId;
    private final String passwordData;
    private final Instant timestamp;

    private GetPasswordDataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.passwordData = builder.passwordData;
        this.timestamp = builder.timestamp;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String passwordData() {
        return this.passwordData;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordData());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPasswordDataResponse)) {
            return false;
        }
        GetPasswordDataResponse other = (GetPasswordDataResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.passwordData(), other.passwordData()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetPasswordDataResponse").add("InstanceId", (Object)this.instanceId()).add("PasswordData", (Object)this.passwordData()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PasswordData": {
                return Optional.ofNullable(clazz.cast(this.passwordData()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPasswordDataResponse, T> g) {
        return obj -> g.apply((GetPasswordDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String passwordData;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPasswordDataResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.passwordData(model.passwordData);
            this.timestamp(model.timestamp);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPasswordData() {
            return this.passwordData;
        }

        public final void setPasswordData(String passwordData) {
            this.passwordData = passwordData;
        }

        @Override
        public final Builder passwordData(String passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public GetPasswordDataResponse build() {
            return new GetPasswordDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPasswordDataResponse> {
        public Builder instanceId(String var1);

        public Builder passwordData(String var1);

        public Builder timestamp(Instant var1);
    }
}

