/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceRequirementsWithMetadataRequest;
import software.amazon.awssdk.services.ec2.model.InstanceTypesCopier;
import software.amazon.awssdk.services.ec2.model.RegionNamesCopier;
import software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSpotPlacementScoresRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetSpotPlacementScoresRequest> {
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypes").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::instanceTypes)).setter(GetSpotPlacementScoresRequest.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCapacity").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::targetCapacity)).setter(GetSpotPlacementScoresRequest.setter(Builder::targetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity").unmarshallLocationName("TargetCapacity").build()}).build();
    private static final SdkField<String> TARGET_CAPACITY_UNIT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCapacityUnitType").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::targetCapacityUnitTypeAsString)).setter(GetSpotPlacementScoresRequest.setter(Builder::targetCapacityUnitType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacityUnitType").unmarshallLocationName("TargetCapacityUnitType").build()}).build();
    private static final SdkField<Boolean> SINGLE_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SingleAvailabilityZone").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::singleAvailabilityZone)).setter(GetSpotPlacementScoresRequest.setter(Builder::singleAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAvailabilityZone").unmarshallLocationName("SingleAvailabilityZone").build()}).build();
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionNames").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::regionNames)).setter(GetSpotPlacementScoresRequest.setter(Builder::regionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("RegionName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceRequirementsWithMetadataRequest> INSTANCE_REQUIREMENTS_WITH_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirementsWithMetadata").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::instanceRequirementsWithMetadata)).setter(GetSpotPlacementScoresRequest.setter(Builder::instanceRequirementsWithMetadata)).constructor(InstanceRequirementsWithMetadataRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirementsWithMetadata").unmarshallLocationName("InstanceRequirementsWithMetadata").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::maxResults)).setter(GetSpotPlacementScoresRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSpotPlacementScoresRequest.getter(GetSpotPlacementScoresRequest::nextToken)).setter(GetSpotPlacementScoresRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD, TARGET_CAPACITY_FIELD, TARGET_CAPACITY_UNIT_TYPE_FIELD, SINGLE_AVAILABILITY_ZONE_FIELD, REGION_NAMES_FIELD, INSTANCE_REQUIREMENTS_WITH_METADATA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> instanceTypes;
    private final Integer targetCapacity;
    private final String targetCapacityUnitType;
    private final Boolean singleAvailabilityZone;
    private final List<String> regionNames;
    private final InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata;
    private final Integer maxResults;
    private final String nextToken;

    private GetSpotPlacementScoresRequest(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.targetCapacity = builder.targetCapacity;
        this.targetCapacityUnitType = builder.targetCapacityUnitType;
        this.singleAvailabilityZone = builder.singleAvailabilityZone;
        this.regionNames = builder.regionNames;
        this.instanceRequirementsWithMetadata = builder.instanceRequirementsWithMetadata;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public final Integer targetCapacity() {
        return this.targetCapacity;
    }

    public final TargetCapacityUnitType targetCapacityUnitType() {
        return TargetCapacityUnitType.fromValue(this.targetCapacityUnitType);
    }

    public final String targetCapacityUnitTypeAsString() {
        return this.targetCapacityUnitType;
    }

    public final Boolean singleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public final boolean hasRegionNames() {
        return this.regionNames != null && !(this.regionNames instanceof SdkAutoConstructList);
    }

    public final List<String> regionNames() {
        return this.regionNames;
    }

    public final InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata() {
        return this.instanceRequirementsWithMetadata;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacityUnitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionNames() ? this.regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirementsWithMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpotPlacementScoresRequest)) {
            return false;
        }
        GetSpotPlacementScoresRequest other = (GetSpotPlacementScoresRequest)((Object)obj);
        return this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.targetCapacity(), other.targetCapacity()) && Objects.equals(this.targetCapacityUnitTypeAsString(), other.targetCapacityUnitTypeAsString()) && Objects.equals(this.singleAvailabilityZone(), other.singleAvailabilityZone()) && this.hasRegionNames() == other.hasRegionNames() && Objects.equals(this.regionNames(), other.regionNames()) && Objects.equals(this.instanceRequirementsWithMetadata(), other.instanceRequirementsWithMetadata()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSpotPlacementScoresRequest").add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("TargetCapacity", (Object)this.targetCapacity()).add("TargetCapacityUnitType", (Object)this.targetCapacityUnitTypeAsString()).add("SingleAvailabilityZone", (Object)this.singleAvailabilityZone()).add("RegionNames", this.hasRegionNames() ? this.regionNames() : null).add("InstanceRequirementsWithMetadata", (Object)this.instanceRequirementsWithMetadata()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "TargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetCapacity()));
            }
            case "TargetCapacityUnitType": {
                return Optional.ofNullable(clazz.cast(this.targetCapacityUnitTypeAsString()));
            }
            case "SingleAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.singleAvailabilityZone()));
            }
            case "RegionNames": {
                return Optional.ofNullable(clazz.cast(this.regionNames()));
            }
            case "InstanceRequirementsWithMetadata": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirementsWithMetadata()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSpotPlacementScoresRequest, T> g) {
        return obj -> g.apply((GetSpotPlacementScoresRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer targetCapacity;
        private String targetCapacityUnitType;
        private Boolean singleAvailabilityZone;
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();
        private InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpotPlacementScoresRequest model) {
            super(model);
            this.instanceTypes(model.instanceTypes);
            this.targetCapacity(model.targetCapacity);
            this.targetCapacityUnitType(model.targetCapacityUnitType);
            this.singleAvailabilityZone(model.singleAvailabilityZone);
            this.regionNames(model.regionNames);
            this.instanceRequirementsWithMetadata(model.instanceRequirementsWithMetadata);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypesCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypesCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final String getTargetCapacityUnitType() {
            return this.targetCapacityUnitType;
        }

        public final void setTargetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
        }

        @Override
        public final Builder targetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
            return this;
        }

        @Override
        public final Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
            this.targetCapacityUnitType(targetCapacityUnitType == null ? null : targetCapacityUnitType.toString());
            return this;
        }

        public final Boolean getSingleAvailabilityZone() {
            return this.singleAvailabilityZone;
        }

        public final void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
        }

        @Override
        public final Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
            return this;
        }

        public final Collection<String> getRegionNames() {
            if (this.regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            this.regionNames = RegionNamesCopier.copy(regionNames);
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            this.regionNames = RegionNamesCopier.copy(regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String ... regionNames) {
            this.regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final InstanceRequirementsWithMetadataRequest.Builder getInstanceRequirementsWithMetadata() {
            return this.instanceRequirementsWithMetadata != null ? this.instanceRequirementsWithMetadata.toBuilder() : null;
        }

        public final void setInstanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest.BuilderImpl instanceRequirementsWithMetadata) {
            this.instanceRequirementsWithMetadata = instanceRequirementsWithMetadata != null ? instanceRequirementsWithMetadata.build() : null;
        }

        @Override
        public final Builder instanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata) {
            this.instanceRequirementsWithMetadata = instanceRequirementsWithMetadata;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSpotPlacementScoresRequest build() {
            return new GetSpotPlacementScoresRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSpotPlacementScoresRequest> {
        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder targetCapacity(Integer var1);

        public Builder targetCapacityUnitType(String var1);

        public Builder targetCapacityUnitType(TargetCapacityUnitType var1);

        public Builder singleAvailabilityZone(Boolean var1);

        public Builder regionNames(Collection<String> var1);

        public Builder regionNames(String ... var1);

        public Builder instanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest var1);

        default public Builder instanceRequirementsWithMetadata(Consumer<InstanceRequirementsWithMetadataRequest.Builder> instanceRequirementsWithMetadata) {
            return this.instanceRequirementsWithMetadata((InstanceRequirementsWithMetadataRequest)((InstanceRequirementsWithMetadataRequest.Builder)InstanceRequirementsWithMetadataRequest.builder().applyMutation(instanceRequirementsWithMetadata)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

